<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }

$activePage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monify Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['"Plus Jakarta Sans"', 'sans-serif'] },
                    colors: { midnight: '#0f172a', sunburst: '#f59e0b', sunburstHover: '#d97706' }
                }
            }
        }
    </script>
    <style>
        body { background-color: #f8fafc; color: #1e293b; }
        .card-panel { background: white; border-radius: 1rem; padding: 2rem; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); border: 1px solid #e2e8f0; margin-bottom: 2rem; }
        .header-bar { display: flex; justify-content: space-between; align-items: center; margin-bottom: 2.5rem; }
        .page-title { font-size: 1.875rem; font-weight: 800; color: #0f172a; letter-spacing: -0.025em; }
        .form-label { display: block; font-weight: 600; font-size: 0.875rem; color: #0f172a; margin-bottom: 0.5rem; }
        .form-input, .form-select { width: 100%; padding: 0.75rem 1rem; border-radius: 0.75rem; border: 1px solid #e2e8f0; background: #fff; transition: all 0.2s; }
        .form-input:focus, .form-select:focus { border-color: #f59e0b; outline: none; box-shadow: 0 0 0 3px rgba(245, 158, 11, 0.2); }
        .btn-primary { display: inline-flex; align-items: center; gap: 0.5rem; background-color: #f59e0b; color: #0f172a; padding: 0.75rem 1.5rem; border-radius: 0.75rem; font-weight: 700; cursor: pointer; border: none; transition: all 0.2s; }
        .btn-primary:hover { background-color: #d97706; transform: translateY(-2px); }
        .badge { display: inline-flex; align-items: center; gap: 0.25rem; padding: 0.25rem 0.75rem; border-radius: 9999px; font-size: 0.75rem; font-weight: 700; }
        ::-webkit-scrollbar { width: 8px; height: 8px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #94a3b8; }
    </style>
</head>
<body class="bg-slate-50 text-slate-800 font-sans antialiased">

<div class="flex min-h-screen relative">
    
    <div id="mobileBackdrop" onclick="mobilMenuKapat()" class="fixed inset-0 bg-midnight/80 z-30 hidden lg:hidden backdrop-blur-sm transition-opacity"></div>

    <aside id="sidebar" class="w-72 bg-midnight text-white flex flex-col fixed h-full shadow-2xl z-40 transform -translate-x-full lg:translate-x-0 transition-transform duration-300 ease-in-out">
        
        <div class="h-24 flex items-center justify-between px-8 border-b border-slate-800">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-sunburst rounded-lg flex items-center justify-center text-midnight font-bold text-xl">
                    <i class="fa-solid fa-bolt"></i>
                </div>
                <span class="text-2xl font-extrabold tracking-tight">Monify.</span>
            </div>
            <button onclick="mobilMenuKapat()" class="lg:hidden text-slate-400 hover:text-white">
                <i class="fa-solid fa-xmark text-2xl"></i>
            </button>
        </div>

        <nav class="flex-1 px-4 py-8 space-y-2 overflow-y-auto">
            <a href="dashboard.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'dashboard.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-grid-2 <?= $activePage == 'dashboard.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'dashboard.php' ? 'font-semibold' : '' ?>">Genel Bakış</span>
            </a>
            <a href="ekle.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'ekle.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-circle-plus <?= $activePage == 'ekle.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'ekle.php' ? 'font-semibold' : '' ?>">İşlem Ekle</span>
            </a>
            <a href="liste.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'liste.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-list-ul <?= $activePage == 'liste.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'liste.php' ? 'font-semibold' : '' ?>">Hareketler</span>
            </a>
            <a href="rapor.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'rapor.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-chart-pie <?= $activePage == 'rapor.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'rapor.php' ? 'font-semibold' : '' ?>">Raporlar</span>
            </a>
            <a href="kategoriler.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'kategoriler.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-tags <?= $activePage == 'kategoriler.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'kategoriler.php' ? 'font-semibold' : '' ?>">Kategoriler</span>
            </a>
            <a href="hesaplar.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'hesaplar.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
    <i class="fa-solid fa-wallet <?= $activePage == 'hesaplar.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
    <span class="font-medium <?= $activePage == 'hesaplar.php' ? 'font-semibold' : '' ?>">Hesaplarım</span>
</a>
            <a href="abonelikler.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'abonelikler.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
    <i class="fa-solid fa-repeat <?= $activePage == 'abonelikler.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
    <span class="font-medium <?= $activePage == 'abonelikler.php' ? 'font-semibold' : '' ?>">Abonelikler</span>
</a>
<a href="butceler.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'butceler.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
    <i class="fa-solid fa-bullseye <?= $activePage == 'butceler.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
    <span class="font-medium <?= $activePage == 'butceler.php' ? 'font-semibold' : '' ?>">Bütçe Hedefleri</span>
</a>
            <a href="profil.php" class="flex items-center gap-4 px-4 py-3.5 rounded-xl transition-all group <?= $activePage == 'profil.php' ? 'bg-slate-800/50 border-l-4 border-sunburst text-white' : 'text-slate-400 hover:text-white hover:bg-slate-800' ?>">
                <i class="fa-solid fa-user-gear <?= $activePage == 'profil.php' ? 'text-sunburst' : 'text-lg group-hover:text-sunburst' ?>"></i>
                <span class="font-medium <?= $activePage == 'profil.php' ? 'font-semibold' : '' ?>">Profil Ayarları</span>
            </a>
            
        </nav>

        <div class="p-6 border-t border-slate-800">
            <div class="flex items-center gap-4">
                <div class="w-10 h-10 rounded-full bg-slate-700 flex items-center justify-center text-sm font-bold border-2 border-slate-600">
                    <?= strtoupper(substr($_SESSION['ad_soyad'], 0, 1)) ?>
                </div>
                <div class="flex-1 overflow-hidden">
                    <div class="text-sm font-semibold text-white truncate"><?= $_SESSION['ad_soyad'] ?></div>
                    <a href="cikis.php" class="text-xs text-red-400 hover:text-red-300 transition-colors">Güvenli Çıkış</a>
                </div>
            </div>
        </div>
    </aside>

    <main class="flex-1 lg:ml-72 p-6 lg:p-10 w-full transition-all duration-300">
        
        <div class="lg:hidden mb-8 flex justify-between items-center bg-white p-4 rounded-xl shadow-sm border border-slate-100">
            <span class="font-bold text-xl text-midnight flex items-center gap-2">
                <i class="fa-solid fa-bolt text-sunburst"></i> Monify.
            </span>
            <button onclick="mobilMenuAc()" class="text-midnight text-2xl p-1 rounded-lg hover:bg-slate-100 transition-colors">
                <i class="fa-solid fa-bars"></i>
            </button>
        </div>

        <script>
            function mobilMenuAc() {
                document.getElementById('sidebar').classList.remove('-translate-x-full');
                document.getElementById('mobileBackdrop').classList.remove('hidden');
            }
            function mobilMenuKapat() {
                document.getElementById('sidebar').classList.add('-translate-x-full');
                document.getElementById('mobileBackdrop').classList.add('hidden');
            }
        </script>