<?php 
include 'db.php';

// Oturum kontrolü
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }
$user_id = $_SESSION['user_id'];

// --- İŞLEMLER ---

// 1. HESAP EKLEME
if (isset($_POST['hesap_ekle'])) {
    $ad = trim($_POST['hesap_adi']);
    $tur = $_POST['tur'];
    $bakiye = $_POST['baslangic_bakiye'];
    
    if(!empty($ad)) {
        $db->prepare("INSERT INTO hesaplar (user_id, hesap_adi, tur, guncel_bakiye) VALUES (?, ?, ?, ?)")
           ->execute([$user_id, $ad, $tur, $bakiye]);
        header("Location: hesaplar.php?durum=eklendi"); exit;
    }
}

// 2. HESAP DÜZENLEME
if (isset($_POST['hesap_guncelle'])) {
    $id = $_POST['edit_id'];
    $ad = trim($_POST['edit_ad']);
    $tur = $_POST['edit_tur'];
    $bakiye = $_POST['edit_bakiye'];
    
    if(!empty($ad)) {
        $db->prepare("UPDATE hesaplar SET hesap_adi=?, tur=?, guncel_bakiye=? WHERE id=? AND user_id=?")
           ->execute([$ad, $tur, $bakiye, $id, $user_id]);
        header("Location: hesaplar.php?durum=guncellendi"); exit;
    }
}

// 3. HESAP SİLME
if (isset($_GET['sil'])) {
    $db->prepare("DELETE FROM hesaplar WHERE id = ? AND user_id = ?")->execute([$_GET['sil'], $user_id]);
    header("Location: hesaplar.php?durum=silindi"); exit;
}

// 4. PARA TRANSFERİ (Sadece Bakiyeyi Etkiler)
if (isset($_POST['transfer_yap'])) {
    $gonderen_id = $_POST['gonderen_hesap'];
    $alici_id = $_POST['alici_hesap'];
    $tutar = $_POST['transfer_tutar'];

    if($gonderen_id != $alici_id && $tutar > 0) {
        $db->prepare("UPDATE hesaplar SET guncel_bakiye = guncel_bakiye - ? WHERE id = ?")->execute([$tutar, $gonderen_id]);
        $db->prepare("UPDATE hesaplar SET guncel_bakiye = guncel_bakiye + ? WHERE id = ?")->execute([$tutar, $alici_id]);
        header("Location: hesaplar.php?durum=transfer_ok"); exit;
    }
}

// 5. HIZLI İŞLEM (Sadece Bakiyeyi Etkiler)
if (isset($_POST['islem_ekle'])) {
    $hesap_id = $_POST['islem_hesap_id'];
    $tutar = $_POST['islem_tutar'];
    $tur = $_POST['islem_tur'];
    
    if($tutar > 0) {
        if($tur == 'gelir') {
            $db->prepare("UPDATE hesaplar SET guncel_bakiye = guncel_bakiye + ? WHERE id = ?")->execute([$tutar, $hesap_id]);
        } else {
            $db->prepare("UPDATE hesaplar SET guncel_bakiye = guncel_bakiye - ? WHERE id = ?")->execute([$tutar, $hesap_id]);
        }
        header("Location: hesaplar.php?durum=islem_ok"); exit;
    }
}

include 'header.php'; 

// Hesapları Çek
$sorgu = $db->prepare("SELECT * FROM hesaplar WHERE user_id = ? ORDER BY guncel_bakiye DESC");
$sorgu->execute([$user_id]);
$hesaplar = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Toplam Varlık (Sadece burası için)
$toplamVarlik = 0;
foreach($hesaplar as $h) { $toplamVarlik += $h['guncel_bakiye']; }
?>

<div class="max-w-6xl mx-auto">
    
    <div class="mb-8 flex flex-col md:flex-row justify-between items-end gap-4">
        <div>
            <h1 class="text-3xl font-bold text-midnight mb-1">Hesaplarım</h1>
            <p class="text-slate-500 font-medium">Banka ve cüzdan varlıklarını yönet.</p>
        </div>
        <div class="bg-midnight text-white px-6 py-3 rounded-xl shadow-lg shadow-midnight/20 flex items-center gap-4">
            <div class="text-right">
                <div class="text-xs text-slate-400 font-bold uppercase tracking-wider">TOPLAM VARLIK</div>
                <div class="text-2xl font-extrabold tracking-tight"><?= number_format($toplamVarlik, 2) ?> ₺</div>
            </div>
            <div class="w-10 h-10 bg-sunburst rounded-lg flex items-center justify-center text-midnight text-xl font-bold">
                <i class="fa-solid fa-vault"></i>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
        <button onclick="modalAc('eklemeModal')" class="bg-white border border-slate-200 p-4 rounded-xl shadow-sm hover:shadow-md hover:border-sunburst transition-all flex flex-col items-center gap-2 group">
            <div class="w-10 h-10 bg-sunburst/10 text-sunburst rounded-full flex items-center justify-center text-xl group-hover:scale-110 transition-transform"><i class="fa-solid fa-plus"></i></div>
            <span class="font-bold text-midnight text-sm">Hesap Ekle</span>
        </button>
        <button onclick="modalAc('transferModal')" class="bg-white border border-slate-200 p-4 rounded-xl shadow-sm hover:shadow-md hover:border-blue-500 transition-all flex flex-col items-center gap-2 group">
            <div class="w-10 h-10 bg-blue-50 text-blue-600 rounded-full flex items-center justify-center text-xl group-hover:scale-110 transition-transform"><i class="fa-solid fa-money-bill-transfer"></i></div>
            <span class="font-bold text-midnight text-sm">Transfer Yap</span>
        </button>
        <button onclick="modalAc('islemModal')" class="bg-white border border-slate-200 p-4 rounded-xl shadow-sm hover:shadow-md hover:border-emerald-500 transition-all flex flex-col items-center gap-2 group">
            <div class="w-10 h-10 bg-emerald-50 text-emerald-600 rounded-full flex items-center justify-center text-xl group-hover:scale-110 transition-transform"><i class="fa-solid fa-money-bill-1-wave"></i></div>
            <span class="font-bold text-midnight text-sm">Bakiye Düzelt</span>
        </button>
    </div>

    <?php if(isset($_GET['durum'])): ?>
        <div class="mb-6 p-4 rounded-xl border flex items-center gap-3 shadow-sm font-bold bg-emerald-50 text-emerald-700 border-emerald-100">
            <i class="fa-solid fa-circle-check text-xl"></i>
            <span>İşlem başarıyla tamamlandı.</span>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php foreach($hesaplar as $h): 
            $ikon = "fa-wallet"; $renk = "bg-emerald-500"; $bg = "bg-emerald-50"; $text = "text-emerald-600";
            if($h['tur'] == 'banka') { $ikon = "fa-building-columns"; $renk = "bg-blue-500"; $bg = "bg-blue-50"; $text = "text-blue-600"; }
            elseif($h['tur'] == 'kredi_karti') { $ikon = "fa-credit-card"; $renk = "bg-rose-500"; $bg = "bg-rose-50"; $text = "text-rose-600"; }
            elseif($h['tur'] == 'altin_doviz') { $ikon = "fa-coins"; $renk = "bg-amber-500"; $bg = "bg-amber-50"; $text = "text-amber-600"; }
        ?>
        <div class="bg-white rounded-2xl p-6 border border-slate-100 shadow-lg hover:shadow-xl transition-all relative overflow-hidden group">
            
            <div class="flex justify-between items-start mb-6">
                <div class="w-12 h-12 rounded-xl <?= $bg ?> flex items-center justify-center <?= $text ?> text-xl shadow-sm">
                    <i class="fa-solid <?= $ikon ?>"></i>
                </div>
                <div class="flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                    <button onclick="duzenleModalAc(<?= htmlspecialchars(json_encode($h)) ?>)" class="w-8 h-8 flex items-center justify-center rounded-lg bg-slate-50 text-slate-400 hover:text-blue-600 hover:bg-blue-50"><i class="fa-solid fa-pen text-xs"></i></button>
                    <a href="?sil=<?= $h['id'] ?>" onclick="return confirm('Silmek istiyor musun?')" class="w-8 h-8 flex items-center justify-center rounded-lg bg-slate-50 text-slate-400 hover:text-red-600 hover:bg-red-50"><i class="fa-solid fa-trash-can text-xs"></i></a>
                </div>
            </div>

            <div>
                <h3 class="font-bold text-midnight text-lg mb-1"><?= htmlspecialchars($h['hesap_adi']) ?></h3>
                <p class="text-xs font-bold text-slate-400 uppercase tracking-wider mb-4">
                    <?php if($h['tur']=='nakit') echo 'Nakit'; elseif($h['tur']=='banka') echo 'Banka'; elseif($h['tur']=='kredi_karti') echo 'Kredi Kartı'; else echo 'Yatırım'; ?>
                </p>
                <div class="text-3xl font-extrabold text-midnight tracking-tight">
                    <?= number_format($h['guncel_bakiye'], 2) ?> <span class="text-lg text-slate-400 font-medium">₺</span>
                </div>
            </div>
            <div class="absolute bottom-0 left-0 w-full h-1 <?= $renk ?>"></div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<div id="eklemeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-wallet text-sunburst"></i> Yeni Hesap</h3>
        <form method="POST">
            <div class="mb-4"><label class="form-label text-xs uppercase text-slate-500">Hesap Adı</label><input type="text" name="hesap_adi" class="form-input font-bold" placeholder="Örn: Ziraat Maaş" required></div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tür</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="cursor-pointer"><input type="radio" name="tur" value="nakit" class="peer sr-only" checked><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-emerald-50 peer-checked:text-emerald-600 peer-checked:border-emerald-200 hover:bg-slate-50">Nakit</div></label>
                    <label class="cursor-pointer"><input type="radio" name="tur" value="banka" class="peer sr-only"><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-blue-50 peer-checked:text-blue-600 peer-checked:border-blue-200 hover:bg-slate-50">Banka</div></label>
                    <label class="cursor-pointer"><input type="radio" name="tur" value="kredi_karti" class="peer sr-only"><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-rose-50 peer-checked:text-rose-600 peer-checked:border-rose-200 hover:bg-slate-50">Kredi Kartı</div></label>
                    <label class="cursor-pointer"><input type="radio" name="tur" value="altin_doviz" class="peer sr-only"><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-amber-50 peer-checked:text-amber-600 peer-checked:border-amber-200 hover:bg-slate-50">Yatırım</div></label>
                </div>
            </div>
            <div class="mb-6"><label class="form-label text-xs uppercase text-slate-500">Bakiye</label><input type="number" name="baslangic_bakiye" class="form-input font-bold" step="0.01" value="0"></div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('eklemeModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="hesap_ekle" class="btn-primary justify-center shadow-lg shadow-amber-500/20">Oluştur</button></div>
        </form>
    </div>
</div>

<div id="transferModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-money-bill-transfer text-blue-600"></i> Para Transferi</h3>
        <form method="POST">
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div><label class="form-label text-xs uppercase text-slate-500">Gönderen</label><select name="gonderen_hesap" class="form-select font-bold"><?php foreach($hesaplar as $h) echo "<option value='{$h['id']}'>{$h['hesap_adi']}</option>"; ?></select></div>
                <div><label class="form-label text-xs uppercase text-slate-500">Alıcı</label><select name="alici_hesap" class="form-select font-bold"><?php foreach($hesaplar as $h) echo "<option value='{$h['id']}'>{$h['hesap_adi']}</option>"; ?></select></div>
            </div>
            <div class="mb-6"><label class="form-label text-xs uppercase text-slate-500">Tutar</label><input type="number" name="transfer_tutar" class="form-input font-bold pl-4" step="0.01" required></div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('transferModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="transfer_yap" class="btn-primary bg-blue-600 text-white hover:bg-blue-700 shadow-lg justify-center">Transfer Et</button></div>
        </form>
    </div>
</div>

<div id="islemModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-bolt text-emerald-600"></i> Bakiye Düzelt</h3>
        <p class="text-xs text-slate-500 mb-4">Bu işlem gelir-gider raporlarına yansımaz, sadece hesap bakiyesini değiştirir.</p>
        <form method="POST">
            <div class="mb-4"><label class="form-label text-xs uppercase text-slate-500">Hesap</label><select name="islem_hesap_id" class="form-select font-bold"><?php foreach($hesaplar as $h) echo "<option value='{$h['id']}'>{$h['hesap_adi']}</option>"; ?></select></div>
            <div class="mb-4"><label class="form-label text-xs uppercase text-slate-500">Tutar</label><input type="number" name="islem_tutar" class="form-input font-bold" step="0.01" required></div>
            <div class="mb-6">
                <label class="form-label text-xs uppercase text-slate-500">İşlem</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="cursor-pointer"><input type="radio" name="islem_tur" value="gelir" class="peer sr-only" checked><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-emerald-50 peer-checked:text-emerald-600 peer-checked:border-emerald-200 hover:bg-slate-50">Para Girişi</div></label>
                    <label class="cursor-pointer"><input type="radio" name="islem_tur" value="gider" class="peer sr-only"><div class="p-2 rounded-lg border text-center text-sm font-bold text-slate-500 peer-checked:bg-red-50 peer-checked:text-red-600 peer-checked:border-red-200 hover:bg-slate-50">Para Çıkışı</div></label>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('islemModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="islem_ekle" class="btn-primary bg-emerald-600 text-white hover:bg-emerald-700 shadow-lg justify-center">Onayla</button></div>
        </form>
    </div>
</div>

<div id="duzenleModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-pen text-sunburst"></i> Düzenle</h3>
        <form method="POST">
            <input type="hidden" name="edit_id" id="edit_id">
            <div class="mb-4"><label class="form-label text-xs uppercase text-slate-500">Hesap Adı</label><input type="text" name="edit_ad" id="edit_ad" class="form-input font-bold" required></div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tür</label>
                <select name="edit_tur" id="edit_tur" class="form-select font-bold">
                    <option value="nakit">Nakit</option><option value="banka">Banka</option><option value="kredi_karti">Kredi Kartı</option><option value="altin_doviz">Yatırım</option>
                </select>
            </div>
            <div class="mb-6"><label class="form-label text-xs uppercase text-slate-500">Güncel Bakiye</label><input type="number" name="edit_bakiye" id="edit_bakiye" class="form-input font-bold" step="0.01"></div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('duzenleModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="hesap_guncelle" class="btn-primary justify-center">Kaydet</button></div>
        </form>
    </div>
</div>

<script>
    function modalAc(id) { document.getElementById(id).classList.remove('hidden'); }
    function modalKapat(id) { document.getElementById(id).classList.add('hidden'); }
    
    function duzenleModalAc(data) {
        document.getElementById('edit_id').value = data.id;
        document.getElementById('edit_ad').value = data.hesap_adi;
        document.getElementById('edit_tur').value = data.tur;
        document.getElementById('edit_bakiye').value = data.guncel_bakiye;
        modalAc('duzenleModal');
    }
    window.onclick = function(event) { if (event.target.classList.contains('fixed')) event.target.classList.add('hidden'); }
</script>

<div class="h-12"></div>
</body>
</html>