<?php
// Oturumu başlat
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Eğer zaten giriş yapmışsa direkt panele yolla
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monify - Finansal Özgürlük</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['"Plus Jakarta Sans"', 'sans-serif'] },
                    colors: {
                        midnight: '#0f172a',
                        sunburst: '#f59e0b',
                        sunburstHover: '#d97706',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white font-sans text-slate-600 selection:bg-sunburst selection:text-white">

    <nav class="fixed w-full z-50 bg-white/80 backdrop-blur-md border-b border-slate-100 transition-all">
        <div class="max-w-7xl mx-auto px-6 h-20 flex justify-between items-center">
            <a href="#" class="flex items-center gap-3 group">
                <div class="w-10 h-10 bg-midnight text-white rounded-xl flex items-center justify-center text-xl shadow-lg group-hover:rotate-12 transition-transform">
                    <i class="fa-solid fa-bolt text-sunburst"></i>
                </div>
                <span class="text-2xl font-extrabold text-midnight tracking-tight">Monify.</span>
            </a>

            <div class="flex items-center gap-6">
                <a href="login.php" class="hidden md:block font-bold text-slate-500 hover:text-midnight transition-colors">Giriş Yap</a>
                <a href="register.php" class="bg-midnight text-white px-6 py-2.5 rounded-xl font-bold shadow-xl shadow-midnight/10 hover:bg-slate-800 transition-all transform hover:-translate-y-0.5">
                    Hemen Başla
                </a>
            </div>
        </div>
    </nav>

    <header class="relative pt-32 pb-20 lg:pt-48 lg:pb-32 overflow-hidden">
        
        <div class="absolute top-0 right-0 w-[800px] h-[800px] bg-slate-50 rounded-full -mr-40 -mt-40 pointer-events-none"></div>
        <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-amber-50 rounded-full blur-3xl -ml-20 -mb-20 pointer-events-none"></div>

        <div class="max-w-4xl mx-auto px-6 text-center relative z-10">
            <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-slate-50 border border-slate-200 text-slate-600 text-xs font-bold mb-8 uppercase tracking-wider shadow-sm">
                <span class="w-2 h-2 rounded-full bg-sunburst animate-pulse"></span> Yeni Nesil Bütçe Takibi
            </div>
            
            <h1 class="text-5xl lg:text-7xl font-extrabold text-midnight mb-6 leading-tight tracking-tight">
                Paranı Yönetmenin <br> 
                <span class="text-transparent bg-clip-text bg-gradient-to-r from-midnight via-slate-700 to-slate-500">En Sade Yolu.</span>
            </h1>
            
            <p class="text-lg text-slate-500 mb-10 max-w-2xl mx-auto leading-relaxed">
                Gelir ve giderlerini takip et, bütçe hedefleri koy ve finansal özgürlüğüne kavuş. 
                Karmaşık tablolar yok, sadece sen ve hedeflerin var.
            </p>
            
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <a href="register.php" class="w-full sm:w-auto px-8 py-4 bg-sunburst text-white font-bold rounded-2xl shadow-xl shadow-sunburst/20 hover:bg-sunburstHover transition-all transform hover:scale-105 flex items-center justify-center gap-2">
                    <i class="fa-solid fa-rocket"></i> Ücretsiz Dene
                </a>
                <a href="login.php" class="w-full sm:w-auto px-8 py-4 bg-white text-midnight font-bold rounded-2xl shadow-md border border-slate-200 hover:border-midnight hover:shadow-lg transition-all flex items-center justify-center gap-2">
                    <i class="fa-solid fa-arrow-right-to-bracket"></i> Giriş Yap
                </a>
            </div>
        </div>
    </header>

    <section class="py-24 bg-white">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="p-8 rounded-3xl bg-slate-50 border border-slate-100 hover:border-slate-300 hover:shadow-xl transition-all group">
                    <div class="w-14 h-14 bg-white rounded-2xl flex items-center justify-center text-2xl text-blue-600 shadow-sm mb-6 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-chart-pie"></i>
                    </div>
                    <h3 class="text-xl font-bold text-midnight mb-3">Detaylı Raporlar</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">Paranın nereye gittiğini grafiklerle gör. Haftalık, aylık ve yıllık analizlerle bütçene hakim ol.</p>
                </div>

                <div class="p-8 rounded-3xl bg-slate-50 border border-slate-100 hover:border-slate-300 hover:shadow-xl transition-all group">
                    <div class="w-14 h-14 bg-white rounded-2xl flex items-center justify-center text-2xl text-emerald-600 shadow-sm mb-6 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-bullseye"></i>
                    </div>
                    <h3 class="text-xl font-bold text-midnight mb-3">Bütçe Hedefleri</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">Kendine limitler koy. Market veya eğlence için bütçe belirle, aşınca seni uyaralım.</p>
                </div>

                <div class="p-8 rounded-3xl bg-slate-50 border border-slate-100 hover:border-slate-300 hover:shadow-xl transition-all group">
                    <div class="w-14 h-14 bg-white rounded-2xl flex items-center justify-center text-2xl text-rose-600 shadow-sm mb-6 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-shield-halved"></i>
                    </div>
                    <h3 class="text-xl font-bold text-midnight mb-3">Tam Güvenlik</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">Verilerin şifrelenir ve güvende tutulur. PIN kodu ve şifreli silme ile kontrol tamamen sende.</p>
                </div>
            </div>
        </div>
    </section>

    <footer class="bg-white border-t border-slate-100 py-12">
        <div class="max-w-7xl mx-auto px-6 flex flex-col md:flex-row justify-between items-center gap-6">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 bg-midnight text-white rounded-lg flex items-center justify-center text-sm font-bold">
                    <i class="fa-solid fa-bolt text-sunburst"></i>
                </div>
                <span class="text-xl font-bold tracking-tight text-midnight">Monify.</span>
            </div>
            
            <div class="text-slate-400 text-sm font-medium">
                &copy; 2025 Monify Project. Tüm hakları saklıdır.
            </div>

            <div class="flex gap-4">
                <a href="#" class="w-10 h-10 rounded-full bg-slate-50 flex items-center justify-center text-slate-400 hover:bg-midnight hover:text-white transition-all"><i class="fa-brands fa-twitter"></i></a>
                <a href="#" class="w-10 h-10 rounded-full bg-slate-50 flex items-center justify-center text-slate-400 hover:bg-midnight hover:text-white transition-all"><i class="fa-brands fa-github"></i></a>
                <a href="#" class="w-10 h-10 rounded-full bg-slate-50 flex items-center justify-center text-slate-400 hover:bg-midnight hover:text-white transition-all"><i class="fa-brands fa-instagram"></i></a>
            </div>
        </div>
    </footer>

</body>
</html>