<?php
include 'db.php';

// Eğer geçici oturum yoksa, login'e at (Kafasına göre giremez)
if(!isset($_SESSION['temp_user_id'])){
    header("Location: login.php");
    exit;
}

if (isset($_POST['pin_dogrula'])) {
    $girilen_pin = $_POST['pin1'] . $_POST['pin2'] . $_POST['pin3'] . $_POST['pin4'];
    $user_id = $_SESSION['temp_user_id'];

    // PIN'i veritabanından çek
    $sql = $db->prepare("SELECT pin_kodu FROM kullanicilar WHERE id = ?");
    $sql->execute([$user_id]);
    $kullanici = $sql->fetch(PDO::FETCH_ASSOC);

    if (password_verify($girilen_pin, $kullanici['pin_kodu'])) {
        // PIN Doğru! Gerçek oturumu başlat
        $_SESSION['user_id'] = $_SESSION['temp_user_id'];
        $_SESSION['ad_soyad'] = $_SESSION['temp_ad_soyad'];
        
        // Geçici verileri sil
        unset($_SESSION['temp_user_id']);
        unset($_SESSION['temp_ad_soyad']);
        
        header("Location: dashboard.php");
        exit;
    } else {
        $hata = "Hatalı PIN kodu!";
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Doğrulama - Monify</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['"Plus Jakarta Sans"', 'sans-serif'] },
                    colors: { midnight: '#0f172a', sunburst: '#f59e0b' }
                }
            }
        }
    </script>
</head>
<body class="bg-midnight min-h-screen flex items-center justify-center p-4">

    <div class="w-full max-w-md bg-white rounded-3xl shadow-2xl p-8 md:p-12 text-center">
        
        <div class="w-16 h-16 bg-blue-50 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-6">
            <i class="fa-solid fa-lock text-2xl"></i>
        </div>

        <h1 class="text-2xl font-bold text-midnight mb-2">Güvenlik Doğrulaması</h1>
        <p class="text-slate-500 text-sm mb-8">Lütfen 4 haneli güvenlik PIN kodunu gir.</p>

        <?php if(isset($hata)): ?>
            <div class="mb-6 text-red-600 font-bold text-sm bg-red-50 py-2 rounded-lg animate-pulse">
                <?= $hata ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="flex justify-center gap-3 mb-8">
                <input type="text" name="pin1" maxlength="1" class="pin-input w-12 h-14 border-2 border-slate-200 rounded-xl text-center text-2xl font-bold text-midnight focus:border-sunburst focus:ring-4 focus:ring-sunburst/10 outline-none transition-all" required autofocus>
                <input type="text" name="pin2" maxlength="1" class="pin-input w-12 h-14 border-2 border-slate-200 rounded-xl text-center text-2xl font-bold text-midnight focus:border-sunburst focus:ring-4 focus:ring-sunburst/10 outline-none transition-all" required>
                <input type="text" name="pin3" maxlength="1" class="pin-input w-12 h-14 border-2 border-slate-200 rounded-xl text-center text-2xl font-bold text-midnight focus:border-sunburst focus:ring-4 focus:ring-sunburst/10 outline-none transition-all" required>
                <input type="text" name="pin4" maxlength="1" class="pin-input w-12 h-14 border-2 border-slate-200 rounded-xl text-center text-2xl font-bold text-midnight focus:border-sunburst focus:ring-4 focus:ring-sunburst/10 outline-none transition-all" required>
            </div>

            <button type="submit" name="pin_dogrula" class="w-full bg-midnight hover:bg-slate-800 text-white font-bold py-3.5 rounded-xl shadow-lg transition-all">
                Doğrula ve Gir
            </button>
        </form>

        <div class="mt-6">
            <a href="login.php" class="text-slate-400 hover:text-slate-600 text-xs font-bold transition-colors">Geri Dön</a>
        </div>
    </div>

    <script>
        // PIN inputları arasında otomatik geçiş scripti
        const inputs = document.querySelectorAll('.pin-input');
        inputs.forEach((input, index) => {
            input.addEventListener('input', (e) => {
                if (e.target.value.length === 1 && index < inputs.length - 1) {
                    inputs[index + 1].focus();
                }
            });
            input.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && e.target.value === '' && index > 0) {
                    inputs[index - 1].focus();
                }
            });
        });
    </script>

</body>
</html>