<?php 
include 'db.php';

// Oturum kontrolü
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
$user_id = $_SESSION['user_id'];

// Kullanıcıyı Çek
$sorgu = $db->prepare("SELECT * FROM kullanicilar WHERE id = ?");
$sorgu->execute([$user_id]);
$kullanici = $sorgu->fetch(PDO::FETCH_ASSOC);

// --- 1. PROFİL BİLGİLERİ GÜNCELLEME ---
if (isset($_POST['profil_guncelle'])) {
    $ad = trim($_POST['ad_soyad']);
    $email = trim($_POST['email']);
    try {
        $db->prepare("UPDATE kullanicilar SET ad_soyad = ?, email = ? WHERE id = ?")->execute([$ad, $email, $user_id]);
        $_SESSION['ad_soyad'] = $ad;
        header("Location: profil.php?durum=profil_ok"); exit;
    } catch (PDOException $e) { $profil_hata = "Bu e-posta kullanımda."; }
}

// --- 2. ŞİFRE DEĞİŞTİRME ---
if (isset($_POST['sifre_guncelle'])) {
    $mevcut = $_POST['mevcut_sifre'];
    $yeni = $_POST['yeni_sifre'];
    $tekrar = $_POST['yeni_sifre_tekrar'];
    
    if (password_verify($mevcut, $kullanici['sifre'])) {
        if ($yeni === $tekrar && strlen($yeni) >= 6) {
            $hash = password_hash($yeni, PASSWORD_DEFAULT);
            $db->prepare("UPDATE kullanicilar SET sifre = ? WHERE id = ?")->execute([$hash, $user_id]);
            header("Location: profil.php?durum=sifre_ok"); exit;
        } else { $sifre_hata = "Şifreler uyuşmuyor veya çok kısa."; }
    } else { $sifre_hata = "Mevcut şifre yanlış."; }
}

// --- 3. PIN KODU AYARLA / KALDIR (GERİ GELDİ!) ---
if (isset($_POST['pin_ayarla'])) {
    $pin = $_POST['pin_kodu'];
    if (preg_match('/^[0-9]{4}$/', $pin)) { 
        $hash_pin = password_hash($pin, PASSWORD_DEFAULT);
        $db->prepare("UPDATE kullanicilar SET pin_kodu = ? WHERE id = ?")->execute([$hash_pin, $user_id]);
        header("Location: profil.php?durum=pin_ok"); exit;
    } else { $pin_hata = "PIN kodu 4 rakam olmalı."; }
}
if (isset($_GET['pin_kaldir'])) {
    $db->prepare("UPDATE kullanicilar SET pin_kodu = NULL WHERE id = ?")->execute([$user_id]);
    header("Location: profil.php?durum=pin_silindi"); exit;
}

// --- 4. VERİLERİ SIFIRLA (Şifre Korumalı) ---
if (isset($_POST['verileri_sifirla'])) {
    if (password_verify($_POST['onay_sifresi'], $kullanici['sifre'])) {
        $db->prepare("DELETE FROM islemler WHERE user_id = ?")->execute([$user_id]);
        $db->prepare("DELETE FROM kategoriler WHERE user_id = ?")->execute([$user_id]);
        header("Location: profil.php?durum=sifirlandi"); exit;
    } else { $genel_hata = "Şifre yanlış girildi."; }
}

// --- 5. HESABI SİL (Şifre Korumalı) ---
if (isset($_POST['hesabi_sil'])) {
    if (password_verify($_POST['silme_sifresi'], $kullanici['sifre'])) {
        $db->prepare("DELETE FROM islemler WHERE user_id = ?")->execute([$user_id]);
        $db->prepare("DELETE FROM kategoriler WHERE user_id = ?")->execute([$user_id]);
        $db->prepare("DELETE FROM kullanicilar WHERE id = ?")->execute([$user_id]);
        session_destroy();
        header("Location: login.php"); exit;
    } else { $genel_hata = "Şifre yanlış, hesap silinemedi."; }
}

include 'header.php'; 
?>

<div class="max-w-6xl mx-auto">
    
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-midnight mb-2">Profil Ayarları</h1>
        <p class="text-slate-500 font-medium">Hesabını, güvenliğini ve verilerini yönet.</p>
    </div>

    <?php if(isset($_GET['durum'])): ?>
        <div class="mb-6 p-4 rounded-xl bg-emerald-50 text-emerald-700 border border-emerald-100 flex items-center gap-3 font-bold animate-pulse-slow">
            <i class="fa-solid fa-circle-check text-xl"></i>
            <?php 
                if($_GET['durum']=='profil_ok') echo "Bilgiler güncellendi.";
                elseif($_GET['durum']=='sifre_ok') echo "Şifreniz değiştirildi.";
                elseif($_GET['durum']=='pin_ok') echo "PIN Kodu aktif edildi! Çıkış yapıp deneyebilirsin.";
                elseif($_GET['durum']=='pin_silindi') echo "PIN Kodu kaldırıldı.";
                elseif($_GET['durum']=='sifirlandi') echo "Tüm veriler temizlendi.";
            ?>
        </div>
    <?php endif; ?>

    <?php if(isset($genel_hata)): ?>
        <div class="mb-6 p-4 rounded-xl bg-red-50 text-red-700 border border-red-100 flex items-center gap-3 font-bold">
            <i class="fa-solid fa-triangle-exclamation text-xl"></i> <?= $genel_hata ?>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        
        <div class="space-y-8">
            
            <div class="card-panel border-t-4 border-t-midnight shadow-lg">
                <h3 class="text-lg font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-user-pen text-sunburst"></i> Kişisel Bilgiler</h3>
                <?php if(isset($profil_hata)): ?><div class="text-red-500 text-sm mb-4 font-bold"><?= $profil_hata ?></div><?php endif; ?>
                <form method="POST">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div><label class="form-label text-xs uppercase text-slate-500">Ad Soyad</label><input type="text" name="ad_soyad" value="<?= htmlspecialchars($kullanici['ad_soyad']) ?>" class="form-input font-bold text-midnight" required></div>
                        <div><label class="form-label text-xs uppercase text-slate-500">E-Posta</label><input type="email" name="email" value="<?= htmlspecialchars($kullanici['email']) ?>" class="form-input font-bold text-midnight" required></div>
                    </div>
                    <button type="submit" name="profil_guncelle" class="btn-primary w-full justify-center bg-slate-100 text-slate-600 hover:bg-midnight hover:text-white border border-slate-200 hover:border-midnight shadow-none">Bilgileri Güncelle</button>
                </form>
            </div>

            <div class="card-panel border-t-4 border-t-blue-600 shadow-lg">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h3 class="text-lg font-bold text-midnight flex items-center gap-2"><i class="fa-solid fa-shield-cat text-blue-600"></i> Güvenlik PIN'i</h3>
                        <p class="text-xs text-slate-500">Girişte sorulacak 4 haneli ek şifre.</p>
                    </div>
                    <?php if(!empty($kullanici['pin_kodu'])): ?>
                        <span class="bg-emerald-100 text-emerald-700 text-xs font-bold px-3 py-1 rounded-full border border-emerald-200">AKTİF</span>
                    <?php else: ?>
                        <span class="bg-slate-100 text-slate-500 text-xs font-bold px-3 py-1 rounded-full border border-slate-200">PASİF</span>
                    <?php endif; ?>
                </div>

                <?php if(isset($pin_hata)): ?><div class="text-red-500 text-sm mb-4 font-bold"><?= $pin_hata ?></div><?php endif; ?>

                <?php if(empty($kullanici['pin_kodu'])): ?>
                    <form method="POST" class="flex gap-4 items-end">
                        <div class="flex-1">
                            <input type="text" name="pin_kodu" maxlength="4" placeholder="••••" class="form-input font-bold text-midnight text-center tracking-[1em] text-lg" required oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');">
                        </div>
                        <button type="submit" name="pin_ayarla" class="btn-primary bg-blue-600 hover:bg-blue-700 text-white shadow-lg shadow-blue-500/30 h-[50px] px-6">Aktif Et</button>
                    </form>
                <?php else: ?>
                    <div class="bg-blue-50 border border-blue-100 p-4 rounded-xl flex items-center justify-between">
                        <div class="text-sm text-blue-800 font-medium">Hesabınız PIN kodu ile korunuyor.</div>
                        <a href="?pin_kaldir=1" onclick="return confirm('Kaldırmak istediğine emin misin?')" class="text-red-500 hover:text-red-700 text-xs font-bold underline">Kodu Kaldır</a>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <div class="space-y-8">
            
            <div class="card-panel border-t-4 border-t-sunburst shadow-lg">
                <h3 class="text-lg font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-lock text-sunburst"></i> Şifre Değiştir</h3>
                <?php if(isset($sifre_hata)): ?><div class="mb-4 p-3 rounded-lg bg-red-50 text-red-600 font-bold border border-red-100"><?= $sifre_hata ?></div><?php endif; ?>
                <form method="POST" class="space-y-4">
                    <div><label class="form-label text-xs uppercase text-slate-500">Mevcut Şifre</label><input type="password" name="mevcut_sifre" class="form-input" required></div>
                    <div class="grid grid-cols-2 gap-4">
                        <div><label class="form-label text-xs uppercase text-slate-500">Yeni Şifre</label><input type="password" name="yeni_sifre" class="form-input" required></div>
                        <div><label class="form-label text-xs uppercase text-slate-500">Tekrar</label><input type="password" name="yeni_sifre_tekrar" class="form-input" required></div>
                    </div>
                    <button type="submit" name="sifre_guncelle" class="btn-primary w-full justify-center shadow-lg shadow-amber-500/20">Şifreyi Güncelle</button>
                </form>
            </div>

            <div class="card-panel border border-slate-200 shadow-none bg-slate-50">
                <h3 class="text-lg font-bold text-midnight mb-4 flex items-center gap-2"><i class="fa-solid fa-database text-slate-400"></i> Veri Merkezi</h3>
                <div class="space-y-3">
                    <a href="indir.php" class="flex items-center justify-between p-3 bg-white border border-slate-200 rounded-xl hover:border-midnight transition-colors group">
                        <span class="text-sm font-bold text-slate-600 group-hover:text-midnight">Verileri İndir (Excel/CSV)</span>
                        <i class="fa-solid fa-download text-slate-400 group-hover:text-midnight"></i>
                    </a>
                    <button onclick="modalAc('sifirlaModal')" class="w-full flex items-center justify-between p-3 bg-white border border-amber-200 rounded-xl hover:bg-amber-50 transition-colors group">
                        <span class="text-sm font-bold text-amber-700">Verileri Sıfırla</span>
                        <i class="fa-solid fa-rotate-left text-amber-500"></i>
                    </button>
                    <button onclick="modalAc('hesapSilModal')" class="w-full flex items-center justify-between p-3 bg-white border border-red-200 rounded-xl hover:bg-red-50 transition-colors group">
                        <span class="text-sm font-bold text-red-600">Hesabımı Sil</span>
                        <i class="fa-solid fa-trash-can text-red-500"></i>
                    </button>
                </div>
            </div>

        </div>
    </div>
</div>

<div id="sifirlaModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/90 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-sm text-center shadow-2xl">
        <h3 class="text-xl font-bold text-midnight mb-2">Verileri Sıfırla?</h3>
        <p class="text-slate-500 text-sm mb-4">Onaylamak için <b>şifreni</b> gir.</p>
        <form method="POST">
            <input type="password" name="onay_sifresi" class="w-full form-input mb-4 text-center font-bold" placeholder="Şifreniz" required>
            <div class="grid grid-cols-2 gap-3">
                <button type="button" onclick="modalKapat('sifirlaModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">Vazgeç</button>
                <button type="submit" name="verileri_sifirla" class="btn-primary bg-amber-500 text-white hover:bg-amber-600 shadow-none justify-center">Sıfırla</button>
            </div>
        </form>
    </div>
</div>

<div id="hesapSilModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/90 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-sm text-center shadow-2xl">
        <h3 class="text-xl font-bold text-midnight mb-2">Hesabı Sil?</h3>
        <p class="text-slate-500 text-sm mb-4">Bu işlem geri alınamaz! <b>Şifreni</b> gir.</p>
        <form method="POST">
            <input type="password" name="silme_sifresi" class="w-full form-input mb-4 text-center font-bold" placeholder="Şifreniz" required>
            <div class="grid grid-cols-2 gap-3">
                <button type="button" onclick="modalKapat('hesapSilModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">Vazgeç</button>
                <button type="submit" name="hesabi_sil" class="btn-primary bg-red-600 text-white hover:bg-red-700 shadow-none justify-center">Evet, Sil</button>
            </div>
        </form>
    </div>
</div>

<script>
    function modalAc(id) { document.getElementById(id).classList.remove('hidden'); }
    function modalKapat(id) { document.getElementById(id).classList.add('hidden'); }
</script>

<div class="h-12"></div>
</body>
</html>