<?php
session_start();

// 🔒 Güvenlik Kontrolü
if (!isset($_SESSION['oturum']) || $_SESSION['oturum'] !== true) {
    header("Location: login.php");
    exit;
}

include '../includes/db.php';

// --- PROJE EKLEME MANTIĞI ---
if (isset($_POST['proje_ekle'])) {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $desc  = mysqli_real_escape_string($conn, $_POST['desc']);
    $link  = mysqli_real_escape_string($conn, $_POST['link']);
    $tags  = mysqli_real_escape_string($conn, $_POST['tags']);

    // Tablonun sütun adının 'description' olduğundan emin ol (Senin kodunda öyleydi)
    $sql = "INSERT INTO projects (title, description, link, tags) VALUES ('$title', '$desc', '$link', '$tags')";
    
    if ($conn->query($sql)) {
        header("Location: ekle.php?mesaj=basarili");
        exit;
    }
}

// --- PROJE SİLME MANTIĞI ---
if (isset($_GET['sil'])) {
    $id = (int)$_GET['sil'];
    $conn->query("DELETE FROM projects WHERE id = $id");
    header("Location: ekle.php?mesaj=silindi");
    exit;
}

// Mevcut projeleri çek
$projeler = $conn->query("SELECT * FROM projects ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <title>Proje Yönetimi | Admin</title>
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-[#FBFBFB] text-[#1a1a1a]">

    <nav class="max-w-5xl mx-auto px-6 py-8 flex justify-between items-center border-b border-gray-100 bg-white shadow-sm md:rounded-b-[2rem]">
        <div class="flex items-center gap-4">
            <a href="index.php" class="p-2 hover:bg-gray-50 rounded-full transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" /></svg>
            </a>
            <h1 class="font-bold italic text-xl tracking-tighter">Admin <span class="text-gray-400">Panel</span></h1>
        </div>
        <div class="flex gap-6 items-center">
            <a href="../index.php" target="_blank" class="text-[10px] font-bold uppercase tracking-widest text-gray-400 hover:text-black transition">Siteyi Gör</a>
            <a href="logout.php" class="text-[10px] font-bold text-red-500 hover:text-red-700 uppercase tracking-widest border border-red-100 px-4 py-2 rounded-full hover:bg-red-50 transition">Çıkış</a>
        </div>
    </nav>

    <main class="max-w-5xl mx-auto px-6 py-12">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">
            
            <div class="lg:col-span-5">
                <div class="bg-white p-8 rounded-[2.5rem] border border-gray-100 shadow-xl shadow-gray-200/50 sticky top-8">
                    <h2 class="text-xl font-black mb-8 italic tracking-tight">Yeni Proje Yayınla</h2>

                    <?php if(isset($_GET['mesaj'])): ?>
                        <div class="mb-6 p-4 bg-black text-white text-[10px] font-bold uppercase tracking-[0.2em] rounded-2xl text-center animate-pulse">
                            <?php echo $_GET['mesaj'] == 'basarili' ? '✨ Proje Eklendi' : '🗑️ Proje Silindi'; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="space-y-4">
                        <div class="space-y-1">
                            <label class="text-[10px] font-bold uppercase text-gray-400 ml-4">Başlık</label>
                            <input type="text" name="title" placeholder="Script Adı" required class="w-full p-5 bg-gray-50 border-none rounded-2xl outline-none text-sm focus:ring-2 focus:ring-black transition-all shadow-inner">
                        </div>
                        
                        <div class="space-y-1">
                            <label class="text-[10px] font-bold uppercase text-gray-400 ml-4">Açıklama</label>
                            <textarea name="desc" rows="3" placeholder="Proje hakkında kısa bilgi..." class="w-full p-5 bg-gray-50 border-none rounded-2xl outline-none text-sm focus:ring-2 focus:ring-black transition-all shadow-inner"></textarea>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div class="space-y-1">
                                <label class="text-[10px] font-bold uppercase text-gray-400 ml-4">Link</label>
                                <input type="text" name="link" placeholder="GitHub / Demo" class="w-full p-5 bg-gray-50 border-none rounded-2xl outline-none text-sm focus:ring-2 focus:ring-black transition-all shadow-inner">
                            </div>
                            <div class="space-y-1">
                                <label class="text-[10px] font-bold uppercase text-gray-400 ml-4">Etiketler</label>
                                <input type="text" name="tags" placeholder="PHP, Tailwind" class="w-full p-5 bg-gray-50 border-none rounded-2xl outline-none text-sm focus:ring-2 focus:ring-black transition-all shadow-inner">
                            </div>
                        </div>
                        
                        <button type="submit" name="proje_ekle" class="w-full py-5 bg-black text-white rounded-2xl font-bold hover:bg-gray-800 transition transform active:scale-[0.98] shadow-lg shadow-gray-200 mt-4">
                            Hemen Yayınla
                        </button>
                    </form>
                </div>
            </div>

            <div class="lg:col-span-7">
                <div class="flex justify-between items-center mb-8 px-2">
                    <h2 class="text-xl font-black italic tracking-tight">Mevcut Projeler</h2>
                    <span class="text-[10px] font-bold bg-gray-100 px-3 py-1 rounded-full uppercase text-gray-500"><?php echo $projeler->num_rows; ?> Kayıt</span>
                </div>

                <div class="flex flex-col gap-4"> <?php if($projeler->num_rows > 0): ?>
                        <?php while($p = $projeler->fetch_assoc()): ?>
                        <div class="flex justify-between items-center p-6 bg-white rounded-[2rem] border border-gray-100 group hover:border-black transition-all duration-300 shadow-sm hover:shadow-xl">
                            <div class="space-y-1">
                                <h3 class="font-bold text-sm tracking-tight group-hover:text-black transition-colors"><?php echo $p['title']; ?></h3>
                                <div class="flex items-center gap-2">
                                    <span class="w-1 h-1 bg-green-500 rounded-full"></span>
                                    <p class="text-[10px] font-bold text-gray-400 uppercase tracking-widest"><?php echo $p['tags']; ?></p>
                                </div>
                            </div>
                            
                            <div class="flex items-center gap-4">
                                <a href="duzenle.php?id=<?php echo $p['id']; ?>" class="text-[10px] font-bold text-gray-300 hover:text-black uppercase tracking-widest transition">Düzenle</a>
                                <div class="w-px h-4 bg-gray-100"></div>
                                <a href="?sil=<?php echo $p['id']; ?>" onclick="return confirm('Projeyi silmek istediğine emin misin?')" class="text-[10px] font-bold text-red-200 hover:text-red-600 uppercase tracking-widest transition">Sil</a>
                            </div>
                        </div> <?php endwhile; ?>
                    <?php else: ?>
                        <div class="p-20 text-center bg-white rounded-[3rem] border-2 border-dashed border-gray-100">
                            <p class="text-gray-300 text-sm font-medium italic">Henüz bir proje eklenmemiş...</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </main>

</body>
</html>