<?php 
include 'includes/db.php'; 
include 'includes/header.php'; 

// Tüm projeleri en yeniden eskiye çekiyoruz
$projeler = $conn->query("SELECT * FROM projects ORDER BY id DESC");
?>

<main class="max-w-3xl mx-auto px-6 pt-24 pb-32">
    <header class="mb-16">
        <h1 class="text-3xl font-bold tracking-tight mb-4 text-gray-900">Açık Kaynak Projelerim</h1>
        <p class="text-gray-500 leading-relaxed">
            Geliştirdiğim tüm scriptleri burada bulabilirsin. Hepsi sade, anlaşılır ve <span class="text-black font-semibold">ücretsizdir.</span>
        </p>
    </header>

    <div class="space-y-6">
        <?php if ($projeler->num_rows > 0): ?>
            <?php while($p = $projeler->fetch_assoc()): ?>
            <article class="group p-6 bg-white border border-gray-100 rounded-2xl hover:shadow-2xl hover:shadow-gray-200/40 transition-all duration-500">
                <div class="flex justify-between items-start mb-4">
                    <div class="flex gap-3 items-center">
                        <span class="w-8 h-8 flex items-center justify-center bg-gray-50 rounded-lg text-xs font-mono text-gray-400 group-hover:bg-black group-hover:text-white transition-all">
                            <?php echo substr($p['title'], 0, 1); ?>
                        </span>
                        <h2 class="text-xl font-semibold"><?php echo $p['title']; ?></h2>
                    </div>
                    <a href="<?php echo $p['link']; ?>" target="_blank" class="text-[10px] font-bold uppercase tracking-widest text-indigo-600 px-3 py-1 bg-indigo-50 rounded-full hover:bg-indigo-600 hover:text-white transition">İncele</a>
                </div>
                <p class="text-gray-600 text-sm mb-6 leading-relaxed">
                    <?php echo $p['description']; ?>
                </p>
                <div class="flex gap-3">
                    <?php 
                    $tags = explode(',', $p['tags']); 
                    foreach($tags as $tag): 
                    ?>
                        <span class="text-[10px] font-bold px-2 py-1 bg-gray-50 rounded text-gray-400 uppercase"><?php echo trim($tag); ?></span>
                    <?php endforeach; ?>
                </div>
            </article>
            <?php endwhile; ?>
        <?php else: ?>
            <p class="text-gray-400 italic">Henüz bir proje eklenmemiş.</p>
        <?php endif; ?>
    </div>
</main>

<?php include 'includes/footer.php'; ?>