<?php 
require_once 'inc/db.php'; 
require_once 'inc/functions.php';

// Ayarları ve Logoyu çek
$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Yazıları Çek
$posts = $db->query("SELECT posts.*, categories.name as cat_name 
                    FROM posts 
                    LEFT JOIN categories ON posts.category_id = categories.id 
                    WHERE status = 'published' 
                    ORDER BY posts.id DESC LIMIT 10")->fetchAll(PDO::FETCH_ASSOC);

$featured = $posts[0] ?? null;
$articles = array_slice($posts, 1);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_title']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #fff; }
        .glass { background: rgba(255, 255, 255, 0.85); backdrop-filter: blur(12px); }
        .hero-gradient { background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.9) 100%); }
    </style>
</head>
<body class="text-slate-900 selection:bg-black selection:text-white">

    <nav class="glass border-b border-slate-100 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-col md:flex-row md:h-20 py-4 md:py-0 justify-between items-center gap-4">
                <a href="index.php" class="flex items-center shrink-0">
                    <?php if(!empty($settings['site_logo'])): ?>
                        <img src="assets/<?php echo $settings['site_logo']; ?>" class="h-8 w-auto">
                    <?php else: ?>
                        <span class="text-2xl font-black tracking-tighter uppercase italic">BLOG<span class="text-indigo-600">.</span>PRO</span>
                    <?php endif; ?>
                </a>

                <div class="w-full md:w-96 order-3 md:order-2">
                    <form action="arama.php" method="GET" class="relative group">
                        <input type="text" name="q" placeholder="İçeriklerde ara..." 
                               class="w-full bg-slate-100 border-none rounded-2xl px-5 py-3 text-xs font-bold outline-none focus:ring-2 focus:ring-black transition-all">
                        <button type="submit" class="absolute right-4 top-3 text-slate-400 group-hover:text-black transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </button>
                    </form>
                </div>

                <div class="flex gap-6 text-[10px] font-black uppercase tracking-widest text-slate-400 order-2 md:order-3">
                    <a href="index.php" class="text-black border-b-2 border-black pb-1">Anasayfa</a>
                    <a href="kategori.php" class="hover:text-black transition">Kategoriler</a>
                </div>
            </div>
        </div>
    </nav>

    <?php if($featured): ?>
    <section class="max-w-7xl mx-auto px-6 py-10">
        <div class="group relative overflow-hidden rounded-[3.5rem] bg-black shadow-2xl shadow-indigo-100">
            <a href="<?php echo $featured['slug']; ?>"> <div class="aspect-[16/9] md:aspect-[21/8] w-full opacity-80 group-hover:opacity-60 transition-all duration-700">
                    <img src="uploads/<?php echo $featured['thumbnail']; ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-[2s]">
                </div>
                <div class="absolute inset-0 hero-gradient flex flex-col justify-end p-8 md:p-20">
                    <span class="bg-white text-black text-[9px] font-black uppercase tracking-[0.2em] px-4 py-1.5 rounded-full w-fit mb-6 shadow-xl">ÖNE ÇIKAN</span>
                    <h2 class="text-white text-4xl md:text-7xl font-extrabold tracking-tighter leading-none max-w-5xl italic"><?php echo $featured['title']; ?></h2>
                    <p class="text-slate-300 mt-6 line-clamp-2 max-w-2xl text-lg font-medium opacity-80 leading-relaxed">
                        <?php echo $featured['meta_desc']; ?>
                    </p>
                </div>
            </a>
        </div>
    </section>
    <?php endif; ?>

    <main class="max-w-7xl mx-auto px-6 py-20">
        <div class="flex items-center gap-6 mb-20">
            <h2 class="text-5xl font-black tracking-tighter uppercase italic">Makaleler<span class="text-indigo-600">.</span></h2>
            <div class="h-[1px] flex-1 bg-slate-100"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-12 gap-y-20">
            <?php foreach($articles as $art): ?>
            <article class="group">
                <a href="<?php echo $art['slug']; ?>"> <div class="relative aspect-[4/3] rounded-[2.5rem] overflow-hidden bg-slate-50 mb-8 shadow-sm group-hover:shadow-2xl transition-all duration-500">
                        <img src="uploads/<?php echo $art['thumbnail']; ?>" class="w-full h-full object-cover grayscale group-hover:grayscale-0 scale-110 group-hover:scale-100 transition-all duration-700">
                        <div class="absolute top-6 left-6">
                            <span class="px-5 py-2 bg-black text-white text-[9px] font-black uppercase tracking-widest rounded-xl shadow-lg">
                                <?php echo $art['cat_name']; ?>
                            </span>
                        </div>
                    </div>
                    <div class="px-2">
                        <h3 class="text-2xl font-bold text-slate-900 leading-tight group-hover:text-indigo-600 transition-colors">
                            <?php echo $art['title']; ?>
                        </h3>
                        <p class="text-slate-400 text-sm font-medium mt-4 line-clamp-2 leading-relaxed italic">
                            <?php echo $art['meta_desc']; ?>
                        </p>
                        <div class="flex items-center gap-3 pt-6 text-[10px] font-black text-slate-300 uppercase tracking-widest">
                            <span><?php echo date('d.m.Y', strtotime($art['created_at'])); ?></span>
                            <span class="text-indigo-600 opacity-0 group-hover:opacity-100 transition-all translate-x-[-10px] group-hover:translate-x-0 ml-auto">OKU →</span>
                        </div>
                    </div>
                </a>
            </article>
            <?php endforeach; ?>
        </div>
    </main>

    <footer class="py-24 text-center border-t border-slate-50">
        <p class="text-slate-400 text-[11px] font-black uppercase tracking-[0.4em]">
            © <?php echo date('Y'); ?> <?php echo $settings['site_footer']; ?>
        </p>
    </footer>

</body>
</html>