<?php 
require_once 'inc/db.php'; 
require_once 'inc/functions.php';

// Site ayarlarını ve Logoyu çek (Logo fix)
$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Kategori ID'sini al
$cat_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($cat_id > 0) {
    // 1. Durum: Belirli bir kategoriye tıklandıysa
    $katSorgu = $db->prepare("SELECT name FROM categories WHERE id = ?");
    $katSorgu->execute([$cat_id]);
    $category = $katSorgu->fetch(PDO::FETCH_ASSOC);

    if (!$category) { header("Location: kategori.php"); exit; }

    // O kategoriye ait yazıları çek (posts tablosu)
    $postSorgu = $db->prepare("SELECT posts.*, categories.name as cat_name FROM posts 
                               LEFT JOIN categories ON posts.category_id = categories.id 
                               WHERE category_id = ? AND status = 'published' ORDER BY id DESC");
    $postSorgu->execute([$cat_id]);
    $posts = $postSorgu->fetchAll(PDO::FETCH_ASSOC);
} else {
    // 2. Durum: Genel kategoriler sayfasıysa tümünü çek
    $allCats = $db->query("SELECT * FROM categories ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ($cat_id > 0) ? $category['name'] : 'Kategoriler'; ?> | <?php echo $settings['site_title']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #fff; }
        .glass { background: rgba(255, 255, 255, 0.85); backdrop-filter: blur(12px); }
    </style>
</head>
<body class="text-slate-900 selection:bg-black selection:text-white">

    <nav class="glass border-b border-slate-100 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-col md:flex-row md:h-20 py-4 md:py-0 justify-between items-center gap-4">
                <a href="index.php" class="flex items-center shrink-0">
                    <?php if(!empty($settings['site_logo'])): ?>
                        <img src="assets/<?php echo $settings['site_logo']; ?>" class="h-7 w-auto">
                    <?php else: ?>
                        <span class="text-2xl font-black tracking-tighter uppercase italic text-slate-900">BLOG<span class="text-indigo-600">.</span>PRO</span>
                    <?php endif; ?>
                </a>

                <div class="w-full md:w-96 order-3 md:order-2">
                    <form action="arama.php" method="GET" class="relative group">
                        <input type="text" name="q" placeholder="Kategorilerde veya yazılarda ara..." 
                               class="w-full bg-slate-100 border-none rounded-2xl px-5 py-3 text-xs font-bold outline-none focus:ring-2 focus:ring-black transition-all">
                        <button type="submit" class="absolute right-4 top-3 text-slate-400 group-hover:text-black transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </button>
                    </form>
                </div>

                <div class="flex gap-6 text-[10px] font-black uppercase tracking-widest text-slate-400 order-2 md:order-3">
                    <a href="index.php" class="hover:text-black transition">Anasayfa</a>
                    <a href="kategori.php" class="<?php echo ($cat_id == 0) ? 'text-black border-b-2 border-black pb-1' : 'hover:text-black transition'; ?>">Kategoriler</a>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-7xl mx-auto px-6 py-20">

        <?php if($cat_id > 0): ?>
            <div class="mb-20">
                <div class="flex items-center gap-4 text-slate-400 text-[10px] font-black uppercase tracking-[0.3em] mb-4">
                    <a href="index.php">ANASAYFA</a>
                    <span>/</span>
                    <a href="kategori.php">KATEGORİLER</a>
                </div>
                <h2 class="text-6xl md:text-8xl font-black tracking-tighter uppercase italic leading-none">
                    #<?php echo $category['name']; ?>
                </h2>
                <div class="h-2 w-24 bg-black mt-8"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-12 gap-y-20">
                <?php if(count($posts) > 0): foreach($posts as $p): ?>
                <article class="group">
                    <a href="<?php echo $p['slug']; ?>"> <div class="relative aspect-[4/3] rounded-[2.5rem] overflow-hidden bg-slate-50 mb-8 shadow-sm group-hover:shadow-2xl transition-all duration-500">
                            <img src="uploads/<?php echo $p['thumbnail']; ?>" class="w-full h-full object-cover grayscale group-hover:grayscale-0 scale-110 group-hover:scale-100 transition-all duration-700">
                        </div>
                        <h3 class="text-2xl font-bold text-slate-900 leading-tight group-hover:text-indigo-600 transition-colors">
                            <?php echo $p['title']; ?>
                        </h3>
                        <p class="text-slate-400 text-sm font-medium mt-4 line-clamp-2 italic">
                            <?php echo $p['meta_desc']; ?>
                        </p>
                    </a>
                </article>
                <?php endforeach; else: ?>
                    <div class="col-span-full py-24 text-center bg-slate-50 rounded-[3rem]">
                        <p class="text-slate-300 font-black uppercase tracking-widest italic">Bu kategoride henüz yazı yok.</p>
                    </div>
                <?php endif; ?>
            </div>

        <?php else: ?>
            <div class="mb-20 text-center">
                <h2 class="text-5xl md:text-7xl font-black tracking-tighter uppercase italic leading-none">
                    Kategoriler Arşivi
                </h2>
                <p class="text-slate-400 mt-6 font-bold uppercase tracking-widest text-xs">Keşfetmek istediğin konuyu seç</p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php foreach($allCats as $c): ?>
                <a href="kategori.php?id=<?php echo $c['id']; ?>" 
                   class="group relative overflow-hidden p-12 border-2 border-slate-100 rounded-[3rem] transition-all hover:bg-black hover:border-black text-center">
                    <h3 class="text-2xl font-black tracking-tighter uppercase italic group-hover:text-white transition-colors">
                        <?php echo $c['name']; ?>
                    </h3>
                    <div class="mt-4 text-[10px] font-black text-slate-300 uppercase tracking-widest group-hover:text-slate-500 transition-colors">
                        İçerikleri Gör →
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </main>

    <footer class="py-24 text-center border-t border-slate-50 mt-20">
        <p class="text-slate-400 text-[11px] font-black uppercase tracking-[0.4em]">
            © <?php echo date('Y'); ?> <?php echo $settings['site_footer']; ?>
        </p>
    </footer>

</body>
</html>