<?php
require_once 'db.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// 1. GİRİŞ KONTROLÜ
if (isset($_POST['login'])) {
    $u = trim($_POST['username']); $p = trim($_POST['password']);
    $q = $db->prepare("SELECT * FROM users WHERE username = ?");
    $q->execute([$u]); $user = $q->fetch(PDO::FETCH_ASSOC);
    if ($user && password_verify($p, $user['password'])) {
        $_SESSION['admin_logged_in'] = true;
    } else { $err = "Hatalı giriş!"; }
}

if (isset($_GET['logout'])) { session_destroy(); header("Location: admin.php"); exit; }

if (!isset($_SESSION['admin_logged_in'])) {
    die('<!DOCTYPE html><html lang="tr"><head><meta charset="UTF-8"><script src="https://cdn.tailwindcss.com"></script><title>Giriş</title></head>
    <body class="bg-[#F8FAFC] flex items-center justify-center h-screen p-4">
    <form method="POST" class="bg-white p-8 md:p-12 rounded-[3rem] shadow-2xl w-full max-w-sm border border-slate-100 text-center">
    <h2 class="text-3xl font-black mb-8 tracking-tighter uppercase italic tracking-[0.2em]">PROJECT.ZERO</h2>'.(isset($err) ? '<p class="text-red-500 text-xs mb-4">'.$err.'</p>' : '').'
    <input type="text" name="username" placeholder="admin" class="w-full p-4 bg-slate-50 rounded-2xl mb-4 border-none focus:ring-2 ring-black outline-none transition-all">
    <input type="password" name="password" placeholder="şifre" class="w-full p-4 bg-slate-50 rounded-2xl mb-6 border-none focus:ring-2 ring-black outline-none transition-all">
    <button name="login" class="w-full bg-black text-white p-4 rounded-2xl font-bold hover:bg-zinc-800 transition uppercase tracking-widest">Giriş Yap</button>
    </form></body></html>');
}

// 2. İŞLEMLER (POST)
if (isset($_POST['add_link'])) { $db->prepare("INSERT INTO links (title, url) VALUES (?, ?)")->execute([$_POST['ltitle'], $_POST['lurl']]); header("Location: admin.php"); exit; }
if (isset($_POST['edit_link'])) { $db->prepare("UPDATE links SET title=?, url=? WHERE id=?")->execute([$_POST['title'], $_POST['url'], $_POST['id']]); header("Location: admin.php"); exit; }
if (isset($_POST['add_social'])) { $db->prepare("INSERT INTO socials (platform, url) VALUES (?, ?)")->execute([$_POST['plat'], $_POST['surl']]); header("Location: admin.php"); exit; }
if (isset($_POST['edit_social'])) { $db->prepare("UPDATE socials SET platform=?, url=? WHERE id=?")->execute([$_POST['plat'], $_POST['surl'], $_POST['id']]); header("Location: admin.php"); exit; }
if (isset($_POST['update_profile'])) {
    $db->prepare("UPDATE settings SET profile_name=?, profile_bio=?, site_title=? WHERE id=1")->execute([$_POST['p_name'], $_POST['p_bio'], $_POST['s_title']]);
    if (!empty($_FILES['p_img']['name'])) { $n = time()."_".$_FILES['p_img']['name']; move_uploaded_file($_FILES['p_img']['tmp_name'], "uploads/".$n); $db->prepare("UPDATE settings SET profile_img=? WHERE id=1")->execute([$n]); }
    header("Location: admin.php"); exit;
}
if (isset($_GET['del_link'])) { $db->prepare("DELETE FROM links WHERE id=?")->execute([$_GET['del_link']]); header("Location: admin.php"); exit; }
if (isset($_GET['del_social'])) { $db->prepare("DELETE FROM socials WHERE id=?")->execute([$_GET['del_social']]); header("Location: admin.php"); exit; }

// 3. VERİ ÇEKME
$s = $db->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$links = $db->query("SELECT * FROM links ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$socials = $db->query("SELECT * FROM socials ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$device_stats = $db->query("SELECT device, COUNT(*) as count FROM analytics GROUP BY device")->fetchAll(PDO::FETCH_ASSOC);
$browser_stats = $db->query("SELECT browser, COUNT(*) as count FROM analytics GROUP BY browser")->fetchAll(PDO::FETCH_ASSOC);

$platforms = ['instagram', 'twitter', 'github', 'youtube', 'linkedin', 'whatsapp', 'tiktok', 'facebook', 'discord', 'spotify'];
$current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['PHP_SELF']) . "/index.php";
$qr_api = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=" . urlencode($current_url);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;800&display=swap" rel="stylesheet">
    <title>Admin | Project Zero</title>
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #fbfbfb; }
        .glass-dark { background: rgba(0, 0, 0, 0.6); backdrop-filter: blur(8px); }
    </style>
</head>
<body class="p-4 md:p-12 text-[#171717]">

    <div class="max-w-7xl mx-auto">
        <header class="bg-white border border-slate-100 p-6 md:p-8 rounded-[2rem] md:rounded-[2.5rem] shadow-sm mb-10 flex flex-col md:flex-row justify-between items-center gap-6">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 bg-black rounded-2xl flex items-center justify-center text-white font-black italic shadow-xl shadow-black/10">0</div>
                <div>
                    <h1 class="text-2xl font-black tracking-tighter uppercase italic leading-none">Project Zero</h1>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none mt-1">Dashboard v4.5</p>
                </div>
            </div>
            <div class="flex gap-2 w-full md:w-auto font-bold text-[10px] uppercase">
                <a href="index.php" target="_blank" class="flex-1 text-center bg-slate-50 px-6 py-3 rounded-2xl border border-slate-100 transition-all hover:bg-slate-100">Siteyi Gör</a>
                <a href="?logout" class="flex-1 text-center bg-red-50 text-red-600 px-6 py-3 rounded-2xl border border-red-50">Çıkış</a>
            </div>
        </header>

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
            
            <div class="lg:col-span-4 space-y-8">
                <section class="bg-white border border-slate-100 p-8 rounded-[2.5rem] shadow-sm">
                    <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-300 mb-6 font-bold">Profil & Site</h3>
                    <form method="POST" enctype="multipart/form-data" class="space-y-4">
                        <div class="flex items-center gap-4 bg-slate-50 p-4 rounded-3xl border">
                            <img src="uploads/<?= !empty($s['profile_img']) ? $s['profile_img'] : 'default.jpg' ?>" class="w-16 h-16 rounded-2xl object-cover border-2 border-white shadow-sm">
                            <input type="file" name="p_img" class="text-[9px] font-bold">
                        </div>
                        <input type="text" name="s_title" value="<?= htmlspecialchars($s['site_title']) ?>" placeholder="Site Adı" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none focus:ring-1 ring-black text-sm">
                        <input type="text" name="p_name" value="<?= htmlspecialchars($s['profile_name']) ?>" placeholder="İsim" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none focus:ring-1 ring-black text-sm">
                        <textarea name="p_bio" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none focus:ring-1 ring-black h-24 text-sm resize-none"><?= htmlspecialchars($s['profile_bio']) ?></textarea>
                        <button name="update_profile" class="w-full bg-black text-white p-4 rounded-2xl font-bold uppercase text-xs shadow-lg shadow-black/10">Kaydet</button>
                    </form>
                </section>

                <section class="bg-white border border-slate-100 p-8 rounded-[2.5rem] shadow-sm text-sm">
                    <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-300 mb-6 font-bold">Sosyal Medya</h3>
                    <form method="POST" class="space-y-3 mb-6">
                        <select name="plat" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none text-[10px] font-bold uppercase tracking-widest">
                            <?php foreach($platforms as $p): ?> <option value="<?= $p ?>"><?= strtoupper($p) ?></option> <?php endforeach; ?>
                        </select>
                        <input type="text" name="surl" placeholder="URL" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none text-xs">
                        <button name="add_social" class="w-full bg-slate-100 p-4 rounded-2xl font-bold text-[10px] uppercase">Ekle</button>
                    </form>
                    <div class="space-y-2">
                        <?php foreach($socials as $soc): ?>
                            <div class="bg-slate-50 px-4 py-3 rounded-2xl text-[10px] font-black uppercase flex items-center justify-between border">
                                <span><?= $soc['platform'] ?></span>
                                <div class="flex gap-3">
                                    <button onclick="editSocial(<?= $soc['id'] ?>, '<?= $soc['platform'] ?>', '<?= $soc['url'] ?>')" class="text-blue-500">DÜZENLE</button>
                                    <button onclick="askDelete('?del_social=<?= $soc['id'] ?>')" class="text-red-500">SİL</button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </section>
            </div>

            <div class="lg:col-span-5 space-y-8">
                <section class="bg-white border-2 border-black p-8 rounded-[2.5rem] shadow-sm relative overflow-hidden group">
                    <div class="absolute -right-4 -bottom-4 opacity-[0.05] rotate-12 group-hover:rotate-0 transition-all duration-700">
                        <svg width="100" height="100" fill="currentColor" viewBox="0 0 24 24"><path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/></svg>
                    </div>
                    <div class="relative z-10 flex items-center gap-6">
                        <div class="w-14 h-14 bg-slate-50 rounded-2xl flex items-center justify-center border border-slate-100 shrink-0">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path></svg>
                        </div>
                        <div>
                            <h3 class="text-[10px] font-black uppercase tracking-[0.3em] text-slate-400 mb-1 leading-none italic">Creator Hub</h3>
                            <p class="text-xs font-bold text-slate-700 leading-snug mb-3">Bu script ücretsiz dağıtılmıştır. Bir teşekkürün yeter!</p>
                            <a href="https://github.com/buraxklc" target="_blank" class="inline-block bg-black text-white px-5 py-2 rounded-xl text-[9px] font-black uppercase tracking-widest hover:scale-105 transition-all">Geliştiriciye Destek Ol</a>
                        </div>
                    </div>
                </section>

                <section class="bg-white border border-slate-100 p-8 rounded-[2.5rem] shadow-sm">
                    <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-300 mb-6 font-bold uppercase italic tracking-[0.2em]">Linklerini Yönet</h3>
                    <form method="POST" class="space-y-3 mb-8 border-b pb-8 border-slate-50 text-sm">
                        <input type="text" name="ltitle" placeholder="Başlık" class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none focus:ring-1 ring-black" required>
                        <input type="url" name="lurl" placeholder="https://..." class="w-full p-4 bg-slate-50 rounded-2xl border-none outline-none focus:ring-1 ring-black" required>
                        <button name="add_link" class="w-full bg-black text-white p-4 rounded-2xl font-bold uppercase text-xs">YENİ LİNK EKLE +</button>
                    </form>
                    <div class="space-y-3">
                        <?php foreach($links as $l): ?>
                            <div class="flex items-center justify-between p-5 bg-slate-50 rounded-3xl border border-slate-100 group">
                                <div class="truncate text-sm font-bold"><?= htmlspecialchars($l['title']) ?></div>
                                <div class="flex gap-3">
                                    <button onclick="editLink(<?= $l['id'] ?>, '<?= addslashes($l['title']) ?>', '<?= $l['url'] ?>')" class="text-[9px] font-black text-slate-400 hover:text-black uppercase">Düzenle</button>
                                    <button onclick="askDelete('?del_link=<?= $l['id'] ?>')" class="w-8 h-8 bg-white text-red-500 rounded-xl flex items-center justify-center border border-red-50 shadow-sm">&times;</button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </section>
            </div>

            <div class="lg:col-span-3 space-y-8">
                <section class="bg-black text-white p-8 rounded-[2.5rem] shadow-xl text-center">
                    <h3 class="text-[9px] font-black uppercase tracking-widest text-slate-500 mb-6 italic italic tracking-[0.2em]">Tekil İzlenme</h3>
                    <h2 class="text-6xl font-black italic tracking-tighter mb-8"><?= number_format($s['total_views']) ?></h2>
                    <div class="space-y-4 pt-6 border-t border-zinc-800 text-[10px] font-bold uppercase tracking-widest">
                        <div class="space-y-1">
                            <?php foreach($device_stats as $ds): ?>
                                <div class="flex justify-between"><span class="text-zinc-500"><?= $ds['device'] ?></span><span><?= $ds['count'] ?></span></div>
                            <?php endforeach; ?>
                        </div>
                        <div class="space-y-1 mt-4">
                            <?php foreach($browser_stats as $bs): ?>
                                <div class="flex justify-between"><span class="text-zinc-500"><?= $bs['browser'] ?></span><span><?= $bs['count'] ?></span></div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </section>

                <section class="bg-white border border-slate-100 p-8 rounded-[2.5rem] shadow-sm text-center">
                    <img src="<?= $qr_api ?>" class="w-32 h-32 mx-auto mb-4 p-2 border border-slate-50 rounded-2xl grayscale">
                    <a href="<?= $qr_api ?>" download class="text-[10px] font-black text-blue-500 uppercase underline tracking-widest">QR İndir</a>
                </section>
            </div>
        </div>
    </div>

    <div id="linkModal" class="hidden fixed inset-0 glass-dark z-50 flex items-center justify-center p-4">
        <form method="POST" class="bg-white w-full max-w-md p-10 rounded-[3rem] shadow-2xl relative">
            <h3 class="text-2xl font-black mb-6 uppercase tracking-tighter italic italic tracking-[0.2em]">Link Düzenle</h3>
            <input type="hidden" name="id" id="edit_link_id">
            <div class="space-y-4">
                <input type="text" name="title" id="edit_link_title" class="w-full p-4 bg-slate-50 rounded-2xl outline-none focus:ring-1 ring-black border-none font-bold text-sm">
                <input type="url" name="url" id="edit_link_url" class="w-full p-4 bg-slate-50 rounded-2xl outline-none focus:ring-1 ring-black border-none font-bold text-sm">
                <button name="edit_link" class="w-full bg-black text-white p-4 rounded-2xl font-bold uppercase text-xs">Kaydet</button>
                <button type="button" onclick="closeModals()" class="w-full text-slate-300 text-[10px] font-bold uppercase tracking-widest mt-2">Vazgeç</button>
            </div>
        </form>
    </div>

    <div id="socialModal" class="hidden fixed inset-0 glass-dark z-50 flex items-center justify-center p-4">
        <form method="POST" class="bg-white w-full max-w-md p-10 rounded-[3rem] shadow-2xl relative border-2 border-black">
            <h3 class="text-2xl font-black mb-6 uppercase tracking-tighter italic italic tracking-[0.2em]">Hesap Düzenle</h3>
            <input type="hidden" name="id" id="edit_soc_id">
            <div class="space-y-4">
                <select name="plat" id="edit_soc_plat" class="w-full p-4 bg-slate-50 rounded-2xl outline-none border-none text-[10px] font-bold uppercase tracking-widest">
                    <?php foreach($platforms as $p): ?> <option value="<?= $p ?>"><?= strtoupper($p) ?></option> <?php endforeach; ?>
                </select>
                <input type="text" name="surl" id="edit_soc_url" class="w-full p-4 bg-slate-50 rounded-2xl outline-none focus:ring-1 ring-black border-none font-bold text-sm">
                <button name="edit_social" class="w-full bg-black text-white p-4 rounded-2xl font-bold uppercase text-xs">Kaydet</button>
                <button type="button" onclick="closeModals()" class="w-full text-slate-300 text-[10px] font-bold uppercase tracking-widest mt-2">Vazgeç</button>
            </div>
        </form>
    </div>

    <div id="deleteModal" class="hidden fixed inset-0 glass-dark z-[60] flex items-center justify-center p-4">
        <div class="bg-white w-full max-w-sm p-10 rounded-[3.5rem] shadow-2xl text-center border-4 border-red-50">
            <div class="w-20 h-20 bg-red-50 text-red-500 rounded-full flex items-center justify-center mx-auto mb-6">
                <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
            </div>
            <h3 class="text-2xl font-black mb-2 uppercase tracking-tighter italic tracking-[0.2em]">Emin misin?</h3>
            <p class="text-slate-400 text-[10px] font-black uppercase mb-8 leading-none tracking-widest">Bu işlem geri alınamaz!</p>
            <div class="flex gap-3">
                <button id="confirmDeleteBtn" class="flex-1 bg-red-500 text-white p-4 rounded-2xl font-bold uppercase text-[10px] hover:bg-red-600 shadow-xl shadow-red-200 transition-all italic">Evet, SİL</button>
                <button onclick="closeModals()" class="flex-1 bg-slate-100 text-slate-400 p-4 rounded-2xl font-bold uppercase text-[10px] tracking-widest">İptal</button>
            </div>
        </div>
    </div>

    <script>
        let deleteUrl = '';

        function editLink(id, title, url) {
            document.getElementById('edit_link_id').value = id;
            document.getElementById('edit_link_title').value = title;
            document.getElementById('edit_link_url').value = url;
            document.getElementById('linkModal').classList.remove('hidden');
        }

        function editSocial(id, platform, url) {
            document.getElementById('edit_soc_id').value = id;
            document.getElementById('edit_soc_plat').value = platform;
            document.getElementById('edit_soc_url').value = url;
            document.getElementById('socialModal').classList.remove('hidden');
        }

        function askDelete(url) {
            deleteUrl = url;
            document.getElementById('deleteModal').classList.remove('hidden');
        }

        document.getElementById('confirmDeleteBtn').onclick = function() {
            window.location.href = deleteUrl;
        }

        function closeModals() {
            document.getElementById('linkModal').classList.add('hidden');
            document.getElementById('socialModal').classList.add('hidden');
            document.getElementById('deleteModal').classList.add('hidden');
        }

        window.onclick = function(event) {
            if (event.target.id.includes('Modal')) closeModals();
        }
    </script>
</body>
</html>