<?php
require_once 'db.php';

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];

    // 1. Tıklama Sayısını Artır
    $db->prepare("UPDATE links SET clicks = clicks + 1 WHERE id = ?")->execute([$id]);

    // 2. Trafik Kaynağını Yakala (İşe yarayan kısım burası!)
    $ref = $_SERVER['HTTP_REFERER'] ?? 'Direct / QR';
    $source = 'Diğer';

    if (strpos($ref, 'instagram.com') !== false) $source = 'Instagram';
    elseif (strpos($ref, 't.co') !== false || strpos($ref, 'twitter.com') !== false) $source = 'Twitter / X';
    elseif (strpos($ref, 'facebook.com') !== false) $source = 'Facebook';
    elseif (strpos($ref, 'tiktok.com') !== false) $source = 'TikTok';
    elseif ($ref == 'Direct / QR') $source = 'Doğrudan / QR';

    // Kaynağı kaydet veya güncelle
    $db->prepare("INSERT INTO traffic_sources (source_name, hit_count) VALUES (?, 1) 
                  ON DUPLICATE KEY UPDATE hit_count = hit_count + 1")->execute([$source]);

    // 3. Yönlendir
    $link = $db->prepare("SELECT url FROM links WHERE id = ?");
    $link->execute([$id]);
    $url = $link->fetchColumn();
    
    if ($url) {
        header("Location: $url");
        exit;
    }
}
header("Location: index.php");