

<?php
require_once 'db.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
date_default_timezone_set('Europe/Istanbul');

// --- AKILLI SAYAÇ (Yenileyince Artmaz) ---
if (!isset($_SESSION['viewed_unique'])) {
    $db->query("UPDATE settings SET total_views = total_views + 1 WHERE id = 1");
    
    $ua = $_SERVER['HTTP_USER_AGENT'];
    $dev = (preg_match('/(android|iphone|ipad)/i', $ua)) ? 'Mobil' : 'Masaüstü';
    $br = 'Diğer';
    if (strpos($ua, 'Chrome')) $br = 'Chrome';
    elseif (strpos($ua, 'Safari')) $br = 'Safari';
    elseif (strpos($ua, 'Firefox')) $br = 'Firefox';

    $db->prepare("INSERT INTO analytics (browser, device) VALUES (?, ?)")->execute([$br, $dev]);
    $_SESSION['viewed_unique'] = true;
}

$s = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$links = $db->query("SELECT * FROM links ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$socials = $db->query("SELECT * FROM socials ORDER BY id DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($s['site_title'] ?? 'Digital Bio') ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;500;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Space Grotesk', sans-serif; background-color: #fbfbfb; color: #000; }
        .bento-card { background: #ffffff; border: 1px solid #eeeeee; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .bento-card:hover { border-color: #000; transform: scale(1.01); box-shadow: 0 10px 30px rgba(0,0,0,0.02); }
        .grid-container { display: grid; grid-template-columns: repeat(4, 1fr); grid-auto-rows: minmax(110px, auto); gap: 1.5rem; }
        @media (max-width: 768px) { .grid-container { grid-template-columns: repeat(2, 1fr); gap: 1rem; } }
    </style>
</head>
<body class="p-6 md:p-12">

    <div class="max-w-4xl mx-auto">
        <div class="grid-container">
            
            <div class="bento-card col-span-2 row-span-2 rounded-[2.5rem] p-8 md:p-10 flex flex-col justify-between">
                <div>
                    <img src="uploads/<?= !empty($s['profile_img']) ? $s['profile_img'] : 'default.jpg' ?>" 
                         class="w-24 h-24 rounded-[2rem] object-cover mb-6 grayscale hover:grayscale-0 transition-all duration-700 shadow-sm border border-slate-100">
                    
                    <h1 class="text-4xl font-bold tracking-tighter mb-3 leading-none italic uppercase">
                        <?= htmlspecialchars($s['profile_name'] ?? 'İsimsiz') ?>
                    </h1>
                    <p class="text-gray-400 font-medium leading-snug text-sm md:text-base">
                        <?= nl2br(htmlspecialchars($s['profile_bio'] ?? '')) ?>
                    </p>
                </div>

                <div class="flex items-center gap-2 mt-6">
                    <?php foreach($socials as $soc): 
                        $plat = strtolower($soc['platform']);
                        $icon = '';
                        switch($plat) {
                            case 'instagram': $icon = '<svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.917 3.917 0 0 0-1.417.923A3.927 3.927 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.916 3.916 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.926 3.926 0 0 0-.923-1.417A3.911 3.911 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 8 0zm0 1.44c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599.28.28.453.546.598.92.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.47 2.47 0 0 1-.599.919c-.28.28-.546.453-.92.598-.281.11-.705.24-1.485.275-.843.039-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.486-.275a2.476 2.476 0 0 1-.919-.599 2.474 2.474 0 0 1-.598-.92c-.11-.281-.24-.705-.275-1.485-.039-.843-.047-1.096-.047-3.231s.008-2.389.047-3.232c.036-.78.166-1.203.275-1.485.145-.373.319-.64.599-.92.28-.28.546-.453.92-.598.281-.11.705-.24 1.485-.275.843-.039 1.096-.047 3.233-.047zm0 2.452a4.108 4.108 0 1 0 0 8.216 4.108 4.108 0 0 0 0-8.216zm0 6.775a2.667 2.667 0 1 1 0-5.334 2.667 2.667 0 0 1 0 5.334zm4.387-7.196a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92z"/></svg>'; break;
                            case 'twitter': case 'x': $icon = '<svg width="14" height="14" fill="currentColor" viewBox="0 0 16 16"><path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865l8.875 11.633Z"/></svg>'; break;
                            case 'whatsapp': $icon = '<svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.06 3.973L0 16l4.104-1.076a7.839 7.839 0 0 0 3.885.93h.005c4.363 0 7.92-3.558 7.924-7.926a7.848 7.848 0 0 0-2.311-5.599zM7.994 14.52a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"/></svg>'; break;
                            case 'github': $icon = '<svg width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M8 0C3.58 0 0 3.58 0 8c0 3.54 2.29 6.53 5.47 7.59.4.07.55-.17.55-.38 0-.19-.01-.82-.01-1.49-2.01.37-2.53-.49-2.69-.94-.09-.23-.48-.94-.82-1.13-.28-.15-.68-.52-.01-.53.63-.01 1.08.58 1.23.82.72 1.21 1.87.87 2.33.66.07-.52.28-.87.51-1.07-1.78-.2-3.64-.89-3.64-3.95 0-.87.31-1.59.82-2.15-.08-.2-.36-1.02.08-2.12 0 0 .67-.21 2.2.82.64-.18 1.32-.27 2-.27.68 0 1.36.09 2 .27 1.53-1.04 2.2-.82 2.2-.82.44 1.1.16 1.92.08 2.12.51.56.82 1.27.82 2.15 0 3.07-1.87 3.75-3.65 3.95.29.25.54.73.54 1.48 0 1.07-.01 1.93-.01 2.2 0 .21.15.46.55.38A8.012 8.012 0 0 0 16 8c0-4.42-3.58-8-8-8z"/></svg>'; break;
                            case 'tiktok': $icon = '<svg width="14" height="14" fill="currentColor" viewBox="0 0 16 16"><path d="M9 0h1.98c.144.715.54 1.617 1.235 2.512C12.895 3.389 13.797 4 15 4v2c-1.753 0-3.07-.814-4-1.829V11a5 5 0 1 1-5-5v2a3 3 0 1 0 3 3V0Z"/></svg>'; break;
                            default: $icon = '<span class="text-[9px] font-bold uppercase">'.substr($plat, 0, 2).'</span>'; break;
                        }
                    ?>
                        <a href="<?= $soc['url'] ?>" target="_blank" class="w-9 h-9 rounded-xl border border-slate-100 flex items-center justify-center hover:bg-black hover:text-white transition-all group">
                             <?= $icon ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="bento-card col-span-2 rounded-[2.5rem] p-8 flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse shadow-[0_0_8px_#22c55e]"></div>
                    <span class="font-bold uppercase tracking-widest text-[10px]">Aktif</span>
                </div>
                <div class="text-4xl font-light tracking-tighter"><?= date('H:i') ?></div>
            </div>

            <?php foreach($links as $link): ?>
                <a href="go.php?id=<?= $link['id'] ?>" target="_blank" class="bento-card col-span-2 rounded-[2.5rem] p-8 flex flex-col justify-center relative group overflow-hidden border-slate-100">
                    <div class="relative z-10">
                        <span class="text-[9px] font-bold text-gray-300 uppercase tracking-widest block mb-1">Bağlantı</span>
                        <h2 class="text-2xl font-bold tracking-tight group-hover:translate-x-2 transition-transform duration-300">
                            <?= htmlspecialchars($link['title']) ?> ↗
                        </h2>
                    </div>
                    <div class="absolute inset-0 bg-slate-50 translate-y-full group-hover:translate-y-0 transition-transform duration-500"></div>
                </a>
            <?php endforeach; ?>

            <div class="bento-card col-span-2 md:col-span-4 rounded-[2.5rem] p-8 flex items-center justify-center bg-black text-white">
                <p class="text-sm font-medium opacity-60 italic tracking-wide">"Geleceği kodla, geçmişi debug et."</p>
            </div>

        </div>

        
</body>
</html>