<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Core</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #FFFFFF; }
        .font-heading { font-family: 'Montserrat', sans-serif; }
        #sidebar { transition: transform 0.3s ease-in-out; }
    </style>
</head>
<body class="flex min-h-screen">

<div class="lg:hidden fixed top-6 right-6 z-[100]">
    <button onclick="toggleSidebar()" class="p-3 bg-white border border-slate-100 shadow-xl rounded-2xl text-slate-900">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M4 6h16M4 12h16m-7 6h7"></path></svg>
    </button>
</div>

<aside id="sidebar" class="w-64 fixed h-full bg-white border-r border-slate-100 p-8 flex flex-col z-[90] -translate-x-full lg:translate-x-0">
    <div class="mb-12 flex items-center gap-3">
        <div class="w-7 h-7 bg-blue-600 rounded-lg flex items-center justify-center text-white font-bold italic text-[10px]">B</div>
        <span class="font-heading font-bold text-lg tracking-tighter text-slate-900 uppercase">ADMIN<span class="text-blue-600">CORE</span></span>
    </div>

    <nav class="flex-1 space-y-1">
        <a href="index.php" class="flex items-center gap-4 px-4 py-3 rounded-xl text-slate-500 font-semibold hover:bg-slate-50 hover:text-blue-600 transition group text-sm">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg> Dashboard
        </a>
        <a href="portfolio.php" class="flex items-center gap-4 px-4 py-3 rounded-xl text-slate-500 font-semibold hover:bg-slate-50 hover:text-blue-600 transition text-sm">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
    Projeler
</a>
        <a href="services.php" class="flex items-center gap-4 px-4 py-3 rounded-xl text-slate-500 font-semibold hover:bg-slate-50 hover:text-blue-600 transition group text-sm">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg> Hizmetler
        </a>
        <a href="messages.php" class="flex items-center gap-4 px-4 py-3 rounded-xl text-slate-500 font-semibold hover:bg-slate-50 hover:text-blue-600 transition group text-sm">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path></svg> İletişim İstekleri
        </a>
        <a href="settings.php" class="flex items-center gap-4 px-4 py-3 rounded-xl text-slate-500 font-semibold hover:bg-slate-50 hover:text-blue-600 transition group text-sm">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path></svg> Ayarlar
        </a>
        
    </nav>

    <div class="mt-auto">
        <a href="process.php?action=logout" class="flex items-center gap-3 px-4 py-2 text-red-500 font-bold text-[10px] uppercase tracking-widest hover:bg-red-50 rounded-xl transition-all">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2.5"><path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
            Çıkış
        </a>
    </div>
</aside>

<main class="flex-1 lg:ml-64 p-6 lg:p-12 pt-12 lg:pt-16 flex flex-col min-h-screen">
<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('-translate-x-full');
    }
</script>