<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';

$serviceCount = $db->query("SELECT count(*) FROM services")->fetchColumn();
$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

include 'includes/header.php'; 
?>

<div class="w-full">
    <div class="mb-12 border-b border-slate-50 pb-8">
        <h2 class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-2 leading-none">Genel Durum</h2>
        <h1 class="font-heading text-4xl lg:text-5xl font-900 text-slate-900 tracking-tighter uppercase italic leading-none">
            Dashboard<span class="text-blue-600">.</span>
        </h1>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-12">
        <div class="bg-white border border-slate-100 p-5 rounded-2xl flex items-center gap-4 transition-all hover:border-blue-200 shadow-sm">
            <div class="w-10 h-10 bg-blue-50 text-blue-600 rounded-xl flex items-center justify-center">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
            </div>
            <div>
                <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest leading-none mb-1">Hizmet Sayısı</p>
                <p class="text-xl font-black text-slate-900 leading-none"><?php echo $serviceCount; ?></p>
            </div>
        </div>

        <div class="lg:col-span-3 bg-slate-50 p-5 rounded-2xl border border-slate-100 flex items-center justify-between">
            <div class="flex items-center gap-4 truncate">
                <div class="w-10 h-10 bg-white rounded-xl flex items-center justify-center text-slate-400">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <div class="truncate">
                    <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-1">Aktif Site</p>
                    <p class="text-xs font-bold text-slate-800 truncate leading-none mt-1"><?php echo htmlspecialchars($settings['site_title']); ?></p>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <span class="w-2 h-2 rounded-full bg-emerald-500"></span>
                <span class="text-[9px] font-bold text-slate-400 uppercase tracking-widest">Sistem Online</span>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
        <a href="service_add.php" class="flex items-center justify-between p-5 rounded-xl bg-white border border-slate-100 hover:border-blue-600 transition-all group">
            <div class="flex items-center gap-4">
                <svg class="w-4 h-4 text-slate-300 group-hover:text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M12 4v16m8-8H4"></path></svg>
                <span class="text-sm font-semibold text-slate-700">Hizmet Yönetimine Git</span>
            </div>
            <svg class="w-4 h-4 text-slate-200 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M9 5l7 7-7 7"></path></svg>
        </a>
        <a href="settings.php" class="flex items-center justify-between p-5 rounded-xl bg-white border border-slate-100 hover:border-blue-600 transition-all group">
            <div class="flex items-center gap-4">
                <svg class="w-4 h-4 text-slate-300 group-hover:text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path></svg>
                <span class="text-sm font-semibold text-slate-700">Genel Ayarları Güncelle</span>
            </div>
            <svg class="w-4 h-4 text-slate-200 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M9 5l7 7-7 7"></path></svg>
        </a>
    </div>
</div>

<?php include 'includes/footer.php'; ?>