<?php session_start(); ?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Giriş Yap | Yönetim Paneli</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body class="bg-slate-50 font-[Inter] h-screen flex items-center justify-center p-6">

<div class="max-w-md w-full">
    <div class="text-center mb-10">
        <h1 class="text-3xl font-black tracking-tighter text-slate-900">ADMIN<span class="text-blue-600">CORE</span></h1>
        <p class="text-slate-500 mt-2 text-sm font-medium">Yönetim paneline erişmek için giriş yapın.</p>
    </div>

    <div class="bg-white p-8 rounded-[2rem] shadow-xl shadow-slate-200/50 border border-slate-100">
        <?php if(isset($_GET['error'])): ?>
            <div class="bg-red-50 text-red-600 p-4 rounded-xl text-sm font-bold mb-6 border border-red-100">
                Hatalı kullanıcı adı veya şifre!
            </div>
        <?php endif; ?>

        <form action="process.php?action=login" method="POST" class="space-y-6">
            <div class="space-y-2">
                <label class="text-xs font-bold text-slate-500 uppercase tracking-widest ml-1">Kullanıcı Adı</label>
                <input type="text" name="username" required class="w-full px-5 py-4 rounded-2xl bg-slate-50 border border-slate-100 focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none font-medium">
            </div>

            <div class="space-y-2">
                <label class="text-xs font-bold text-slate-500 uppercase tracking-widest ml-1">Şifre</label>
                <input type="password" name="password" required class="w-full px-5 py-4 rounded-2xl bg-slate-50 border border-slate-100 focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all outline-none font-medium">
            </div>

            <button type="submit" class="w-full bg-slate-900 text-white py-4 rounded-2xl font-bold hover:bg-blue-600 transition-all shadow-lg shadow-slate-200 active:scale-[0.98]">
                Sisteme Giriş Yap
            </button>
        </form>
    </div>
</div>

</body>
</html>