<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 
$projects = $db->query("SELECT * FROM portfolio ORDER BY order_no ASC")->fetchAll();
?>

<div class="mb-10 flex items-center justify-between">
    <div>
        <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-1">Vitrin Yönetimi</p>
        <h1 class="text-2xl font-bold text-slate-900 tracking-tight">Projeler / Portfolyo</h1>
    </div>
    <a href="portfolio_add.php" class="bg-slate-900 text-white px-6 py-3 rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-600 transition-all">Yeni Proje</a>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <?php foreach($projects as $p): ?>
    <div class="bg-white border border-slate-100 p-4 rounded-3xl shadow-sm group">
        <div class="aspect-video bg-slate-50 rounded-2xl overflow-hidden mb-4 border border-slate-50">
            <img src="../assets/img/<?php echo $p['image']; ?>" class="w-full h-full object-cover">
        </div>
        <div class="flex justify-between items-center">
            <div>
                <p class="text-[9px] font-bold text-blue-600 uppercase mb-1"><?php echo $p['category']; ?></p>
                <h4 class="text-sm font-bold text-slate-800"><?php echo $p['title']; ?></h4>
            </div>
            <a href="process.php?action=delete_project&id=<?php echo $p['id']; ?>" class="p-2 text-slate-300 hover:text-red-600 transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
            </a>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php include 'includes/footer.php'; ?>