<?php 
require_once 'auth.php'; 
require_once '../includes/db.php';
include 'includes/header.php'; 
?>

<div class="mb-10">
    <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-1">Vitrin</p>
    <h1 class="text-2xl font-bold text-slate-900 tracking-tight leading-none">Yeni Proje Ekle</h1>
</div>

<div class="max-w-3xl">
    <form action="process.php?action=add_project" method="POST" enctype="multipart/form-data" class="bg-white border border-slate-100 p-8 rounded-[2rem] shadow-sm space-y-6">
        
        <div class="grid md:grid-cols-2 gap-6">
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Proje Başlığı</label>
                <input type="text" name="title" required placeholder="Örn: Modern Villa" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
            <div class="space-y-2">
                <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Kategori</label>
                <input type="text" name="category" required placeholder="Örn: Mimari / Yazılım" class="w-full px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
            </div>
        </div>

        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Proje Görseli</label>
            <div class="p-8 border-2 border-dashed border-slate-100 rounded-2xl flex flex-col items-center justify-center bg-slate-50/30 group hover:border-blue-200 transition-all">
                <svg class="w-8 h-8 text-slate-300 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                <input type="file" name="image" required class="text-[10px] text-slate-400">
            </div>
        </div>

        <div class="space-y-2">
            <label class="text-[10px] font-bold text-slate-400 uppercase tracking-widest ml-1">Sıralama</label>
            <input type="number" name="order_no" value="0" class="w-32 px-5 py-3.5 rounded-xl bg-slate-50 border border-slate-100 outline-none text-sm font-semibold focus:border-blue-600 transition-all">
        </div>

        <button type="submit" class="w-full bg-slate-900 text-white py-4 rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-600 transition-all shadow-xl shadow-slate-100">
            Projeyi Yayınla
        </button>
    </form>
</div>

<?php include 'includes/footer.php'; ?>