<?php
session_start();
require_once '../includes/db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}

$action = $_GET['action'] ?? '';

// GENEL AYARLARI GÜNCELLE
if ($action == 'update_settings') {
    $site_title = $_POST['site_title'];
    $site_url = $_POST['site_url'];
    $site_email = $_POST['site_email'];
    $site_phone = $_POST['site_phone'];
    $site_address = $_POST['site_address'];
    $about_text = $_POST['about_text'];
    $seo_title = $_POST['seo_title'];
    $seo_desc = $_POST['seo_desc'];
    $seo_keywords = $_POST['seo_keywords'];
    $stats_projects = $_POST['stats_projects'];
    $stats_experience = $_POST['stats_experience'];
    $stats_clients = $_POST['stats_clients'];

    // Mevcut verileri çek (Eski resimleri silmemek için)
    $oldSettings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
    $target_dir = "../assets/img/";

    // Dosya Yükleme Fonksiyonu
    function handleUpload($file, $target_dir, $old_name) {
        if (isset($file) && $file['error'] == 0) {
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            $new_name = uniqid() . "." . $ext;
            if (move_uploaded_file($file['tmp_name'], $target_dir . $new_name)) {
                // Eski dosyayı klasörden sil (opsiyonel)
                if (!empty($old_name) && file_exists($target_dir . $old_name)) {
                    @unlink($target_dir . $old_name);
                }
                return $new_name;
            }
        }
        return $old_name;
    }

    $site_logo = handleUpload($_FILES['site_logo'], $target_dir, $oldSettings['site_logo']);
    $site_favicon = handleUpload($_FILES['site_favicon'], $target_dir, $oldSettings['site_favicon']);
    $hero_image = handleUpload($_FILES['hero_image'], $target_dir, $oldSettings['hero_image']);

    $sql = "UPDATE settings SET 
            site_title=?, site_url=?, site_email=?, site_phone=?, site_address=?, 
            about_text=?, seo_title=?, seo_desc=?, seo_keywords=?, 
            stats_projects=?, stats_experience=?, stats_clients=?,
            site_logo=?, site_favicon=?, hero_image=? 
            WHERE id = 1";

    $stmt = $db->prepare($sql);
    $stmt->execute([
        $site_title, $site_url, $site_email, $site_phone, $site_address,
        $about_text, $seo_title, $seo_desc, $seo_keywords,
        $stats_projects, $stats_experience, $stats_clients,
        $site_logo, $site_favicon, $hero_image
    ]);

    header("Location: settings.php?ok=1");
    exit;
}

// HİZMET EKLEME
if ($action == 'add_service') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $icon = $_POST['icon'];
    $order_no = $_POST['order_no'];
    
    $image_name = "";
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $image_name = "srv_" . uniqid() . "." . pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        move_uploaded_file($_FILES['image']['tmp_name'], "../assets/img/" . $image_name);
    }

    $sql = "INSERT INTO services (title, description, icon, image, order_no) VALUES (?, ?, ?, ?, ?)";
    $db->prepare($sql)->execute([$title, $description, $icon, $image_name, $order_no]);
    header("Location: services.php?ok=1");
    exit;
}

// PROJE EKLEME
if ($action == 'add_project') {
    $title = $_POST['title'];
    $category = $_POST['category'];
    $order_no = $_POST['order_no'];
    
    $image_name = "";
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $image_name = "proj_" . uniqid() . "." . pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        move_uploaded_file($_FILES['image']['tmp_name'], "../assets/img/" . $image_name);
    }

    $sql = "INSERT INTO portfolio (title, category, image, order_no) VALUES (?, ?, ?, ?)";
    $db->prepare($sql)->execute([$title, $category, $image_name, $order_no]);
    header("Location: portfolio.php?ok=1");
    exit;
}

// MESAJ GÖNDERME (FRONTEND)
if ($action == 'send_message') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];

    $sql = "INSERT INTO messages (name, email, subject, message) VALUES (?, ?, ?, ?)";
    $db->prepare($sql)->execute([$name, $email, $subject, $message]);
    header("Location: ../contact?success=1");
    exit;
}