<!DOCTYPE html>
<html lang="tr" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title><?php echo isset($browser_title) ? $browser_title : $site['site_title']; ?></title>
    
    <meta name="description" content="<?php echo htmlspecialchars($site['seo_desc'] ?? ''); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($site['seo_keywords'] ?? ''); ?>">
    
    <?php if(!empty($site['site_favicon'])): ?>
        <link rel="icon" type="image/png" href="assets/img/<?php echo $site['site_favicon']; ?>">
    <?php endif; ?>

    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@800;900&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Inter', sans-serif; }
        .font-heading { font-family: 'Montserrat', sans-serif; }
        .nav-link { position: relative; transition: all 0.3s; }
        .nav-link::after { 
            content: ''; position: absolute; bottom: -4px; left: 0; width: 0; 
            height: 2px; background: #2563eb; transition: width 0.3s; 
        }
        .nav-link:hover::after { width: 100%; }
        .glass-header { 
            background: rgba(255, 255, 255, 0.8); 
            backdrop-filter: blur(12px); 
            -webkit-backdrop-filter: blur(12px);
        }
    </style>
</head>
<body class="bg-white text-slate-900 antialiased">

<header class="fixed top-0 left-0 w-full z-[100] glass-header border-b border-slate-50">
    <div class="max-w-7xl mx-auto px-8 h-24 flex items-center justify-between">
        
        <a href="home" class="flex items-center gap-3 group">
            <?php if(!empty($site['site_logo'])): ?>
                <img src="assets/img/<?php echo $site['site_logo']; ?>" alt="Logo" class="h-10 w-auto group-hover:scale-105 transition-transform">
            <?php else: ?>
                <span class="text-xl font-heading font-900 tracking-tighter uppercase text-slate-900">
                    <?php echo $site['site_title']; ?><span class="text-blue-600">.</span>
                </span>
            <?php endif; ?>
        </a>

        <nav class="hidden lg:flex items-center gap-10">
            <div class="flex gap-8 text-[10px] font-bold uppercase tracking-[0.25em] text-slate-400">
                <a href="home" class="nav-link hover:text-blue-600 <?php echo $page == 'home' ? 'text-blue-600' : ''; ?>">Ana Sayfa</a>
                <a href="about" class="nav-link hover:text-blue-600 <?php echo $page == 'about' ? 'text-blue-600' : ''; ?>">Hakkımızda</a>
                <a href="services" class="nav-link hover:text-blue-600 <?php echo $page == 'services' ? 'text-blue-600' : ''; ?>">Hizmetler</a>
                <a href="portfolio" class="nav-link hover:text-blue-600 <?php echo $page == 'portfolio' ? 'text-blue-600' : ''; ?>">Projeler</a>
                <a href="contact" class="nav-link hover:text-blue-600 <?php echo $page == 'contact' ? 'text-blue-600' : ''; ?>">İletişim</a>
            </div>
            
            <a href="contact" class="bg-slate-900 text-white px-8 py-3.5 rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-600 transition-all shadow-xl shadow-slate-100">
                Teklif Al
            </a>
        </nav>

        <button id="mobile-toggle" class="lg:hidden p-2 text-slate-900">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path>
            </svg>
        </button>
    </div>

    <div id="mobile-menu" class="hidden lg:hidden bg-white border-t border-slate-50 absolute w-full left-0 top-24 p-8 shadow-2xl">
        <div class="flex flex-col gap-6 text-[11px] font-bold uppercase tracking-widest text-slate-500">
            <a href="home" class="hover:text-blue-600">Ana Sayfa</a>
            <a href="about" class="hover:text-blue-600">Hakkımızda</a>
            <a href="services" class="hover:text-blue-600">Hizmetler</a>
            <a href="portfolio" class="hover:text-blue-600">Projeler</a>
            <a href="contact" class="hover:text-blue-600 text-blue-600">İletişim</a>
        </div>
    </div>
</header>

<script>
    // Mobil Menü Aç/Kapat
    const toggle = document.getElementById('mobile-toggle');
    const menu = document.getElementById('mobile-menu');
    
    toggle.addEventListener('click', () => {
        menu.classList.toggle('hidden');
    });
</script>

<div class="pt-24"></div>