<section class="pt-40 pb-12 lg:pt-52 lg:pb-16 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="max-w-2xl">
            <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-3">İletişim</p>
            <h1 class="font-heading text-3xl lg:text-5xl font-900 leading-tight tracking-tighter text-slate-900 uppercase">
                Bize Bir Mesaj <br> <span class="text-blue-600">Bırakın.</span>
            </h1>
        </div>
    </div>
</section>

<section class="pb-32 bg-white">
    <div class="max-w-7xl mx-auto px-8 grid lg:grid-cols-12 gap-16">
        
        <div class="lg:col-span-4 space-y-10">
            <div class="space-y-6">
                <div class="flex items-center gap-4 group">
                    <div class="w-10 h-10 rounded-xl bg-slate-50 border border-slate-100 flex items-center justify-center text-blue-600 group-hover:bg-blue-600 group-hover:text-white transition-all shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                    </div>
                    <div>
                        <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-0.5">Telefon</p>
                        <p class="text-sm font-bold text-slate-800"><?php echo htmlspecialchars($site['site_phone']); ?></p>
                    </div>
                </div>

                <div class="flex items-center gap-4 group">
                    <div class="w-10 h-10 rounded-xl bg-slate-50 border border-slate-100 flex items-center justify-center text-blue-600 group-hover:bg-blue-600 group-hover:text-white transition-all shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                    </div>
                    <div>
                        <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-0.5">E-Posta</p>
                        <p class="text-sm font-bold text-slate-800"><?php echo htmlspecialchars($site['site_email']); ?></p>
                    </div>
                </div>

                <div class="flex items-center gap-4 group">
                    <div class="w-10 h-10 rounded-xl bg-slate-50 border border-slate-100 flex items-center justify-center text-blue-600 group-hover:bg-blue-600 group-hover:text-white transition-all shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2"><path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                    </div>
                    <div>
                        <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mb-0.5">Adres</p>
                        <p class="text-xs font-semibold text-slate-500 leading-relaxed"><?php echo nl2br(htmlspecialchars($site['site_address'])); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="lg:col-span-8">
            <form action="admin/process.php?action=send_message" method="POST" class="space-y-6">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <input type="text" name="name" placeholder="Adınız Soyadınız" required class="w-full px-6 py-4 rounded-2xl bg-slate-50 border border-slate-100 outline-none focus:border-blue-600 transition-all text-sm font-medium">
        <input type="email" name="email" placeholder="E-Posta Adresiniz" required class="w-full px-6 py-4 rounded-2xl bg-slate-50 border border-slate-100 outline-none focus:border-blue-600 transition-all text-sm font-medium">
    </div>
    <input type="text" name="subject" placeholder="Konu" required class="w-full px-6 py-4 rounded-2xl bg-slate-50 border border-slate-100 outline-none focus:border-blue-600 transition-all text-sm font-medium">
    <textarea name="message" rows="6" placeholder="Mesajınız" required class="w-full px-6 py-4 rounded-2xl bg-slate-50 border border-slate-100 outline-none focus:border-blue-600 transition-all text-sm font-medium resize-none"></textarea>
    
    <button type="submit" class="w-full bg-slate-900 text-white py-5 rounded-2xl font-bold text-xs uppercase tracking-[0.3em] hover:bg-blue-600 transition-all shadow-xl shadow-slate-100">
        Mesajı Gönder
    </button>
</form>
                </div>
            </form>
        </div>

    </div>
</section>