<?php
// Verileri çekiyoruz
$h_services = $db->query("SELECT * FROM services ORDER BY order_no ASC LIMIT 4")->fetchAll(PDO::FETCH_ASSOC);
$h_projects = $db->query("SELECT * FROM portfolio ORDER BY order_no ASC LIMIT 4")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
/* Sonsuz Marka Bandı - Orta Boyut & Akıcı */
@keyframes scroll {
    0% { transform: translateX(0); }
    100% { transform: translateX(calc(-200px * 10)); }
}
.brand-slider { overflow: hidden; padding: 40px 0; background: #fff; border-top: 1px solid #f8fafc; border-bottom: 1px solid #f8fafc; }
.brand-track { display: flex; width: calc(200px * 20); animation: scroll 35s linear infinite; }
.brand-item { width: 200px; flex-shrink: 0; display: flex; justify-content: center; align-items: center; }
.brand-item img { height: 24px; opacity: 0.25; filter: grayscale(100%); transition: all 0.4s; }
.brand-item img:hover { opacity: 0.8; filter: grayscale(0%); }

/* Orta Boyut Tipografi */
.hero-title { font-size: clamp(2.2rem, 5vw, 3.2rem); line-height: 1.1; letter-spacing: -0.03em; }
</style>

<section class="relative pt-36 pb-16 lg:pt-48 lg:pb-24 bg-white overflow-hidden">
    <div class="max-w-6xl mx-auto px-8">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            
            <div class="space-y-6">
                <div class="inline-flex items-center gap-2 px-3 py-1.5 rounded-lg bg-slate-50 border border-slate-100">
                    <span class="w-1.5 h-1.5 rounded-full bg-blue-600"></span>
                    <span class="text-[9px] font-bold uppercase tracking-widest text-slate-500">Dijital Tasarım Stüdyosu</span>
                </div>
                
                <h1 class="hero-title font-heading font-900 text-slate-900 uppercase">
                    Geleceği <br> <span class="text-blue-600">Sadelikle</span> <br> Tasarlıyoruz.
                </h1>

                <p class="text-base text-slate-400 font-medium max-w-md leading-relaxed">
                    <?php echo htmlspecialchars($site['site_title']); ?>, modern teknolojiler ve minimalist estetikle işletmenizi dijital dünyada bir adım öne taşır.
                </p>

                <div class="pt-4">
                    <a href="contact" class="inline-block bg-slate-900 text-white px-10 py-4 rounded-xl font-bold text-[10px] uppercase tracking-widest hover:bg-blue-600 transition-all shadow-lg shadow-slate-100">
                        Projenizi Başlatın
                    </a>
                </div>
            </div>

            <div class="relative">
                <div class="relative w-full aspect-[4/3] rounded-[2rem] overflow-hidden shadow-2xl shadow-slate-200/50 border-4 border-white bg-slate-50">
                    <?php if(!empty($site['hero_image'])): ?>
                        <img src="assets/img/<?php echo $site['hero_image']; ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center bg-slate-50 text-[10px] text-slate-300 font-bold uppercase tracking-widest">Görsel Alanı</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-12 bg-white border-y border-slate-50">
    <div class="max-w-6xl mx-auto px-8 grid grid-cols-1 md:grid-cols-3 gap-12">
        <div class="flex items-start gap-4">
            <span class="text-2xl font-black text-blue-600/20 italic">01.</span>
            <div>
                <h4 class="text-xs font-black text-slate-900 uppercase tracking-widest mb-1">Modern Kod</h4>
                <p class="text-[10px] text-slate-400 font-medium uppercase leading-tight tracking-tight">Hızlı ve güvenli güncel yazılım dilleri.</p>
            </div>
        </div>
        <div class="flex items-start gap-4">
            <span class="text-2xl font-black text-blue-600/20 italic">02.</span>
            <div>
                <h4 class="text-xs font-black text-slate-900 uppercase tracking-widest mb-1">Zamanında Teslim</h4>
                <p class="text-[10px] text-slate-400 font-medium uppercase leading-tight tracking-tight">Planlı süreç yönetimiyle tam vaktinde yayında.</p>
            </div>
        </div>
        <div class="flex items-start gap-4">
            <span class="text-2xl font-black text-blue-600/20 italic">03.</span>
            <div>
                <h4 class="text-xs font-black text-slate-900 uppercase tracking-widest mb-1">Tam Destek</h4>
                <p class="text-[10px] text-slate-400 font-medium uppercase leading-tight tracking-tight">Proje sonrası kesintisiz teknik danışmanlık.</p>
            </div>
        </div>
    </div>
</section>

<section class="py-24 bg-slate-50/50">
    <div class="max-w-6xl mx-auto px-8">
        <div class="mb-16">
            <p class="text-blue-600 text-[9px] font-black uppercase tracking-[0.4em] mb-3 leading-none">Neler Sunuyoruz?</p>
            <h2 class="text-3xl font-heading font-900 tracking-tighter text-slate-900 uppercase italic">Uzmanlık Alanları</h2>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php foreach($h_services as $hs): ?>
            <div class="group aspect-square relative bg-white border border-slate-200/60 p-10 flex flex-col justify-between hover:shadow-xl hover:-translate-y-1 transition-all duration-500 rounded-[2.5rem]">
                <div class="w-12 h-12 text-blue-600 bg-slate-50 rounded-2xl flex items-center justify-center group-hover:bg-blue-600 group-hover:text-white transition-all duration-300">
                    <div class="w-6 h-6"><?php echo $hs['icon']; ?></div>
                </div>
                <div>
                    <h3 class="text-base font-bold text-slate-900 uppercase tracking-tighter mb-3 leading-tight"><?php echo htmlspecialchars($hs['title']); ?></h3>
                    <p class="text-[10px] text-slate-400 font-bold uppercase tracking-tight leading-relaxed opacity-0 group-hover:opacity-100 transition-opacity duration-500">
                        <?php echo substr($hs['description'], 0, 70); ?>...
                    </p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<div class="brand-slider">
    <div class="brand-track">
        <?php 
        // 10 Farklı Dünya Markası Logosu
        $logos = [
            "https://upload.wikimedia.org/wikipedia/commons/f/fa/Apple_logo_black.svg",
            "https://upload.wikimedia.org/wikipedia/commons/7/7b/Meta_Platforms_Inc._logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/4/44/Microsoft_logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/a/a9/Amazon_logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/2/2f/Google_2015_logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/0/08/Netflix_2015_logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/2/26/Spotify_logo_with_text.svg",
            "https://upload.wikimedia.org/wikipedia/commons/a/a6/Logo_NIKE.svg",
            "https://upload.wikimedia.org/wikipedia/commons/6/62/Tesla_Motors_Logo.svg",
            "https://upload.wikimedia.org/wikipedia/commons/2/20/Adidas_Logo.svg"
        ];
        
        // Akışın kesilmemesi için listeyi iki kez döndürüyoruz
        foreach(array_merge($logos, $logos) as $l): ?>
        <div class="brand-item">
            <img src="<?php echo $l; ?>" alt="Marka" style="max-width: 100px; max-height: 24px;">
        </div>
        <?php endforeach; ?>
    </div>
</div>

<section class="py-24 bg-white">
    <div class="max-w-6xl mx-auto px-8">
        <div class="flex justify-between items-end mb-16">
            <h2 class="text-3xl lg:text-4xl font-heading font-900 tracking-tighter text-slate-900 uppercase italic">Seçkin Projeler</h2>
            <a href="portfolio" class="text-[10px] font-black uppercase tracking-widest border-b border-slate-900 pb-1">Tümünü Gör</a>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
            <?php foreach($h_projects as $hp): ?>
            <div class="group">
                <div class="aspect-video overflow-hidden rounded-[2rem] bg-slate-50 border border-slate-100 mb-6 transition-all duration-700">
                    <img src="assets/img/<?php echo $hp['image']; ?>" class="w-full h-full object-cover grayscale group-hover:grayscale-0 group-hover:scale-105 transition-all duration-1000">
                </div>
                <div class="flex justify-between items-center px-2">
                    <h4 class="text-base font-bold text-slate-900 uppercase tracking-tighter"><?php echo htmlspecialchars($hp['title']); ?></h4>
                    <span class="text-[9px] font-black text-blue-600 uppercase tracking-widest"><?php echo htmlspecialchars($hp['category']); ?></span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>