<?php
// Ana dizindeki index.php'de bu veriyi çekmiştik ama çekmediysen buraya ekle:
$projects = $db->query("SELECT * FROM portfolio ORDER BY order_no ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="pt-40 pb-16 lg:pt-52 lg:pb-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="max-w-2xl">
            <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-3">Vitrinimiz</p>
            <h1 class="text-3xl lg:text-5xl font-heading font-900 tracking-tighter text-slate-900 uppercase">
                Tamamlanan <br> <span class="text-blue-600">Başarı Hikayeleri.</span>
            </h1>
        </div>
    </div>
</section>

<section class="pb-32 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
            
            <?php if (!empty($projects)): foreach($projects as $p): ?>
            <div class="group cursor-pointer">
                <div class="aspect-[16/10] bg-slate-50 rounded-[2.5rem] overflow-hidden border border-slate-50 mb-6 shadow-sm">
                    <img src="assets/img/<?php echo $p['image']; ?>" alt="<?php echo htmlspecialchars($p['title']); ?>" class="w-full h-full object-cover grayscale group-hover:grayscale-0 transition-all duration-700 group-hover:scale-105">
                </div>
                <div class="px-4">
                    <p class="text-[9px] font-bold text-blue-600 uppercase tracking-[0.3em] mb-2"><?php echo htmlspecialchars($p['category']); ?></p>
                    <h3 class="text-xl font-bold text-slate-900 tracking-tight uppercase"><?php echo htmlspecialchars($p['title']); ?></h3>
                </div>
            </div>
            <?php endforeach; else: ?>
                <p class="text-slate-300 italic">Henüz bir proje eklenmemiş.</p>
            <?php endif; ?>

        </div>
    </div>
</section>