<?php
// index.php üzerinden gelen $services değişkenini kullanıyoruz.
// Eğer değişken boş gelirse hata vermemesi için kontrol ekliyoruz.
if (!isset($services)) {
    $services = $db->query("SELECT * FROM services ORDER BY order_no ASC")->fetchAll(PDO::FETCH_ASSOC);
}
?>

<section class="pt-48 pb-16 lg:pt-60 lg:pb-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="max-w-3xl">
            <p class="text-blue-600 text-[10px] font-bold uppercase tracking-[0.4em] mb-4 leading-none text-center md:text-left">Çözüm Kümemiz</p>
            <h1 class="font-heading text-4xl lg:text-7xl font-900 leading-[0.9] tracking-tighter text-slate-900 uppercase text-center md:text-left">
                Neler <br> <span class="text-blue-600">Sunuyoruz?</span>
            </h1>
        </div>
    </div>
</section>

<section class="pb-40 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-12 lg:gap-16">
            
            <?php if (!empty($services)): foreach($services as $s): ?>
            <div class="group flex flex-col bg-white rounded-[3rem] border border-slate-100 overflow-hidden hover:shadow-2xl hover:shadow-slate-200/50 transition-all duration-700">
                
                <?php if(!empty($s['image'])): ?>
                <div class="aspect-video w-full overflow-hidden relative">
                    <img src="assets/img/<?php echo $s['image']; ?>" 
                         alt="<?php echo htmlspecialchars($s['title']); ?>" 
                         class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-1000 grayscale group-hover:grayscale-0">
                    <div class="absolute inset-0 bg-slate-900/5 group-hover:bg-transparent transition-colors"></div>
                </div>
                <?php endif; ?>

                <div class="p-10 lg:p-12 flex flex-col flex-1">
                    
                    <?php if(!empty($s['icon'])): ?>
                    <div class="w-10 h-10 mb-8 text-blue-600 group-hover:scale-110 transition-transform duration-500">
                        <?php echo $s['icon']; ?>
                    </div>
                    <?php endif; ?>

                    <h3 class="text-xl lg:text-2xl font-bold text-slate-900 mb-5 tracking-tight uppercase leading-tight">
                        <?php echo htmlspecialchars($s['title']); ?>
                    </h3>
                    
                    <p class="text-slate-500 text-sm leading-relaxed font-medium mb-10">
                        <?php echo htmlspecialchars($s['description']); ?>
                    </p>

                    <div class="mt-auto pt-8 border-t border-slate-50 flex justify-between items-center">
                        <span class="text-[9px] font-black text-slate-300 uppercase tracking-widest">
                            Hizmet #<?php echo str_pad($s['order_no'], 2, '0', STR_PAD_LEFT); ?>
                        </span>
                        <div class="w-10 h-10 rounded-full bg-slate-50 text-slate-400 flex items-center justify-center group-hover:bg-blue-600 group-hover:text-white transition-all duration-300 shadow-sm">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3">
                                <path d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; else: ?>
                <div class="col-span-full py-32 text-center border-2 border-dashed border-slate-50 rounded-[3rem]">
                    <p class="text-slate-300 italic font-medium tracking-wide">Henüz bir hizmet tanımlanmamış.</p>
                </div>
            <?php endif; ?>

        </div>
    </div>
</section>