<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CodeSnap - Modern Code Sharer</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism-tomorrow.min.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;500&family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f8fafc; }
        .code-font { font-family: 'Fira Code', monospace; }
        #capture-area { transition: all 0.3s ease; }
        textarea { resize: none; border: 1px solid #e2e8f0; }
        pre[class*="language-"] { margin: 0 !important; background: transparent !important; }
    </style>
</head>
<body class="min-h-screen py-12 px-4">

    <div class="max-w-6xl mx-auto">
        <div class="text-center mb-10">
            <h1 class="text-4xl font-extrabold text-slate-900 tracking-tight">Code<span class="text-blue-600">Snap</span></h1>
            <p class="text-slate-500 mt-2 font-medium">Kodlarınızı saniyeler içinde şık görsellere dönüştürün.</p>
        </div>

        <div class="grid lg:grid-cols-2 gap-10 items-start">
            
            <div class="space-y-6">
                <div class="bg-white p-8 rounded-3xl shadow-sm border border-slate-200">
                    <div>
                        <label class="block text-sm font-bold text-slate-700 mb-2">Kodunuzu Buraya Yapıştırın</label>
                        <textarea id="code-input" oninput="updatePreview()" 
                            class="w-full h-80 p-5 bg-slate-50 rounded-2xl code-font text-[13px] focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all"
                            placeholder="// Kodunuzu buraya yazın..."
                        ></textarea>
                    </div>

                    <div class="grid grid-cols-2 gap-4 mt-6">
                        <div class="space-y-2">
                            <label class="text-xs font-bold text-slate-500 uppercase ml-1">Arka Plan</label>
                            <select id="bg-select" onchange="updatePreview()" class="w-full p-3 bg-white border border-slate-200 rounded-xl text-sm font-semibold outline-none focus:border-blue-500 cursor-pointer">
                                <option value="bg-gradient-to-br from-indigo-500 via-purple-500 to-pink-500">Modern Sunset</option>
                                <option value="bg-gradient-to-br from-blue-600 via-blue-500 to-cyan-400">Deep Blue</option>
                                <option value="bg-gradient-to-br from-emerald-500 to-teal-600">Forest Green</option>
                                <option value="bg-slate-900">Midnight Dark</option>
                                <option value="bg-orange-500">Orange</option>
                            </select>
                        </div>
                        <div class="space-y-2">
                            <label class="text-xs font-bold text-slate-500 uppercase ml-1">Dil</label>
                            <select id="lang-select" onchange="updatePreview()" class="w-full p-3 bg-white border border-slate-200 rounded-xl text-sm font-semibold outline-none focus:border-indigo-500 cursor-pointer">
                                <option value="php">PHP</option>
                                <option value="javascript">JavaScript</option>
                                <option value="html">HTML</option>
                                <option value="css">CSS</option>
                            </select>
                        </div>
                    </div>

                    <button onclick="downloadImage()" class="w-full mt-6 bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 rounded-2xl shadow-lg shadow-blue-200 transition-all flex items-center justify-center gap-2 active:scale-95">
                        <i class="fas fa-camera"></i>
                        Görseli İndir (.PNG)
                    </button>
                </div>

                <div class="bg-white p-6 rounded-3xl shadow-sm border border-slate-200 flex items-center justify-between group transition-all hover:border-orange-200">
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-blue-50 rounded-2xl flex items-center justify-center text-orange-600 transition-transform group-hover:scale-110">
                            <i class="fab fa-instagram text-xl"></i>
                        </div>
                        <div>
                            <h4 class="text-sm font-bold text-slate-800">Burak Kılıç</h4>
                            <p class="text-xs text-slate-500">Bu proje ücretsiz olarak dağıtılmıştır.</p>
                        </div>
                    </div>
                    <a href="https://instagram.com/klcburak.0" target="_blank" class="bg-slate-900 hover:bg-orange-600 text-white text-xs font-bold px-5 py-2.5 rounded-xl transition-colors flex items-center gap-2">
                        <i class="fab fa-instagram text-sm"></i>
                        Takip Et
                    </a>
                </div>
            </div>

            <div class="flex flex-col items-center lg:sticky lg:top-12">
                <div id="capture-area" class="p-12 md:p-16 rounded-[2.5rem] bg-gradient-to-br from-indigo-500 via-purple-500 to-pink-500 shadow-2xl w-full">
                    <div class="bg-[#1e1e1e] rounded-xl shadow-2xl overflow-hidden w-full border border-white/10">
                        <div class="flex items-center px-4 py-3 bg-black/20 gap-2">
                            <div class="w-3 h-3 rounded-full bg-[#ff5f56]"></div>
                            <div class="w-3 h-3 rounded-full bg-[#ffbd2e]"></div>
                            <div class="w-3 h-3 rounded-full bg-[#27c93f]"></div>
                            <div class="ml-auto text-[10px] text-white/30 font-bold uppercase tracking-widest px-2" id="lang-label">PHP</div>
                        </div>
                        <pre class="p-8"><code id="preview-code" class="language-php code-font text-[15px] leading-relaxed"></code></pre>
                    </div>
                </div>
                <p class="mt-6 text-slate-400 text-xs font-medium italic">Değişiklikler anlık olarak yansıtılır.</p>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/prism.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-php.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-javascript.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

    <script>
        function updatePreview() {
            const code = document.getElementById('code-input').value;
            const lang = document.getElementById('lang-select').value;
            const bg = document.getElementById('bg-select').value;
            const previewCode = document.getElementById('preview-code');
            const captureArea = document.getElementById('capture-area');
            const langLabel = document.getElementById('lang-label');

            captureArea.className = `p-12 md:p-16 rounded-[2.5rem] shadow-2xl w-full ${bg}`;
            langLabel.innerText = lang.toUpperCase();
            previewCode.className = `language-${lang} code-font text-[15px] leading-relaxed`;
            previewCode.textContent = code || "// Kodunuzu buraya yazın...";
            
            Prism.highlightElement(previewCode);
        }

        async function downloadImage() {
            const captureArea = document.getElementById('capture-area');
            const canvas = await html2canvas(captureArea, { backgroundColor: null, scale: 3 });
            const link = document.createElement('a');
            link.download = 'CodeSnap-Export.png';
            link.href = canvas.toDataURL('image/png');
            link.click();
        }

        // Başlangıç Değeri
        document.getElementById('code-input').value = "<" + "?php" + "\n\nfunction selamVer() {\n    echo 'Selamlar';\n}\n\nselamVer();\n\n?" + ">";
        updatePreview();
        
        // Konsol İmzası (Görünmez Reklam)
        console.log("%c Developed by klcburak.0 ", "background: #2563eb; color: #fff; font-weight: bold; padding: 4px; border-radius: 4px;");
    </script>
</body>
</html>