<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$taskId = $input['task_id'] ?? null;

if (!$taskId) {
    echo json_encode(['success' => false, 'message' => 'Görev ID gerekli']);
    exit;
}

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("SELECT * FROM tasks WHERE id = ?");
    $stmt->execute([$taskId]);
    $task = $stmt->fetch();
    
    if (!$task) {
        echo json_encode(['success' => false, 'message' => 'Görev bulunamadı']);
        exit;
    }
    
    $stmt = $pdo->prepare("DELETE FROM tasks WHERE id = ?");
    $stmt->execute([$taskId]);
    
    $stmt = $pdo->prepare("UPDATE tasks SET position = position - 1 WHERE status = ? AND position > ?");
    $stmt->execute([$task['status'], $task['position']]);
    
    echo json_encode(['success' => true, 'message' => 'Görev silindi']);
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Veritabanı hatası']);
}